<?php
session_start();

// Check if logout is requested
if (isset($_GET['logout'])) {
    // Unset all session variables
    $_SESSION = array();

    // Destroy the session
    session_destroy();

    // Redirect to the login page
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        /* Reset default styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* Basic styling */
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            display: flex;
        }

        .sidebar {
            width: 250px;
            height: 100vh; /* Full height sidebar */
            background-color: blueviolet; /* Nice blue background color */
            color: #fff;
            padding-top: 10px;
            position: fixed; /* Fixed position to stay visible */
            top: 0;
            left: 0;
            overflow-y: auto; /* Allow scrolling if content exceeds height */
        }

        .sidebar-header {
            text-align: center;
            padding: 10px 0;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }

        .sidebar-menu {
            list-style-type: none;
            padding: 0;
        }

        .sidebar-menu li {
            padding: 10px;
        }

        .sidebar-menu li a {
            color: #fff;
            text-decoration: none;
            display: flex;
            align-items: center;
            padding: 10px;
            transition: background-color 0.3s ease;
        }

        .sidebar-menu li a:hover {
            background-color: #2670b9; /* Darker shade of blue on hover */
        }

        .icon {
            margin-right: 10px;
        }

        /* Main content */
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center; /* Center content horizontally */
            align-items: center; /* Center content vertically */
            flex-direction: column; /* Stack content vertically */
            padding: 20px;
            margin-left: 250px; /* Adjusted to match sidebar width */
            box-sizing: border-box;
            background: url('w.jpg') no-repeat center center/cover; /* Background image */
            height: 100vh; /* Full height */
            overflow-y: auto; /* Allow scrolling */
        }

        /* Welcome message */
        .welcome-message {
            text-align: center;
            color: white;
            font-size: 1rem;
            margin-bottom: 20px;
            padding: 1px 5px;
        }

        /* User icon */
        .user-icon {
            font-size: 3.5rem;
            color: black; /* Black color */
            margin-bottom: 2px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
        
        </div>
        <ul class="sidebar-menu">
        <?php
        if(isset($_SESSION['username']) && isset($_SESSION['access_level'])) {
            $username = $_SESSION['username'];
            $access_level = $_SESSION['access_level'];
            
            echo '<div class="user-icon">
                    <i class="fas fa-user-circle"></i>
                  </div>';
            echo '<div class="welcome-message">
                    <h4>Welcome '.$username.'</h4>
                  </div>';
            
            // Determine which menu items to display based on access level
            if ($access_level === 'Support') {
                echo '<li><a href="?logout"><i class="fas fa-sign-out-alt icon"></i>Logout</a></li>';
            
                echo '<li><a href="search.php"><i class="fas fa-cogs icon"></i>Manual Excel Sheet</a></li>';
                echo '<li><a href="view_vehicles.php"><i class="fas fa-cogs icon"></i>Ideal Units</a></li>';
            } elseif ($access_level === 'Admin') {
                echo '<li><a href="?logout"><i class="fas fa-sign-out-alt icon"></i>Logout</a></li>';
           
                echo '<li><a href="search.php"><i class="fas fa-file-excel icon"></i>Manual Excel Sheet</a></li>';

                echo '<li><a href="view_vehicles.php"><i class="fas fa-car icon"></i>Ideal Units</a></li>';
                echo '<li><a href="salespeople.php"><i class="fas fa-user-plus icon"></i>Add Sales Person</a></li>';
                echo '<li><a href="add_technician.php"><i class="fas fa-tools icon"></i>Add Technician</a></li>';
                echo '<li><a href="edit.php"><i class="fas fa-edit icon"></i>Edit Record</a></li>';
                echo '<li><a href="add_gadget_type.php"><i class="fas fa-th-list icon"></i>Add Gadget Type</a></li>';
                echo '<li><a href="add_gadget.php"><i class="fas fa-microchip icon"></i>Add Gadget Sample</a></li>';
                
                // Vehicle is hidden for Admin level
            } elseif ($access_level === 'Lkamura') {
                echo '<li><a href="?logout"><i class="fas fa-sign-out-alt icon"></i>Logout</a></li>';
       
                echo '<li><a href="oldrecord.php"><i class="fas fa-cogs icon"></i>Manual Excel Sheet</a></li>';
                echo '<li><a href="view_vehicles.php"><i class="fas fa-cogs icon"></i>Ideal Units</a></li>';
                echo '<li><a href="insert_user.php"><i class="fas fa-cogs icon"></i>insert_user.php</a></li>';
            } else {
                // Handle unexpected access levels or redirect to login
                header("Location: login.php");
                exit();
            }
        } else {
            header("Location: login.php"); // Redirect if not logged in
            exit();
        }
        ?>
        </ul>
    </div>

    <!-- Main content -->
    <div class="main-content">
      
    </div>
    
</body>
</html>
