<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add User</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        /* Basic styling */
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        form {
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 300px;
        }

        input[type="text"], select {
            width: 100%;
            padding: 8px;
            margin: 5px 0;
            display: inline-block;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }

        input[type="submit"] {
            background-color: #2670b9;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }

        input[type="submit"]:hover {
            background-color: #005fa3;
        }
    </style>
</head>
<body>
    <div style="text-align:center;">
        <h2>User Data Insertion</h2>

        <?php
        // Include database connection file
        include 'conn.php';

        // Initialize variables to store user input
        $user_id = $name = $access_level = '';
        $user_id_err = $name_err = $access_level_err = '';

        // Check if form is submitted
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            // Validate user_id
            if (isset($_POST['user_id']) && !empty(trim($_POST['user_id']))) {
                $user_id = mysqli_real_escape_string($conn, trim($_POST['user_id']));
            } else {
                $user_id_err = "Please enter a user ID.";
            }

            // Validate name
            if (isset($_POST['name']) && !empty(trim($_POST['name']))) {
                $name = mysqli_real_escape_string($conn, trim($_POST['name']));
            } else {
                $name_err = "Please enter a name.";
            }

            // Validate access level
            if (isset($_POST['access_level']) && !empty($_POST['access_level'])) {
                $access_level = mysqli_real_escape_string($conn, $_POST['access_level']);
            } else {
                $access_level_err = "Please select an access level.";
            }

            // Insert data into database if no errors
            if (empty($user_id_err) && empty($name_err) && empty($access_level_err)) {
                $query = "INSERT INTO users (user_id, name, access_level) VALUES ('$user_id', '$name', '$access_level')";

                if (mysqli_query($conn, $query)) {
                    echo '<div style="color:green;text-align:center;">User added successfully!</div>';
                    // Clear form values after successful submission
                    $user_id = $name = $access_level = '';
                } else {
                    echo '<div style="color:red;text-align:center;">Error: ' . mysqli_error($conn) . '</div>';
                }
            }

            // Close connection
            mysqli_close($conn);
        }
        ?>

        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
            <label for="user_id">User ID:</label><br>
            <input type="text" id="user_id" name="user_id" value="<?php echo htmlspecialchars($user_id); ?>"><br>
            <span style="color:red;"><?php echo $user_id_err; ?></span><br><br>

            <label for="name">Name:</label><br>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>"><br>
            <span style="color:red;"><?php echo $name_err; ?></span><br><br>

            <label for="access_level">Access Level:</label><br>
            <select id="access_level" name="access_level">
                <option value="" <?php if (empty($access_level)) echo 'selected'; ?>>Select Access Level</option>
                <option value="MD" <?php if ($access_level == 'MD') echo 'selected'; ?>>MD</option>
                <option value="Admin" <?php if ($access_level == 'Admin') echo 'selected'; ?>>Admin</option>
                <option value="Ideal" <?php if ($access_level == 'Ideal') echo 'selected'; ?>>Ideal</option>
                <option value="Support" <?php if ($access_level == 'Support') echo 'selected'; ?>>Support</option>
        
            </select><br>
            <span style="color:red;"><?php echo $access_level_err; ?></span><br><br>

            <input type="submit" value="Submit">
        </form>
    </div>
</body>
</html>
