<!DOCTYPE html>
<html>
<head>
    <title>Search Vehicle Details</title>
    <style>
        /* Global styles */
        body {
            font-family: Arial, sans-serif;
            padding: 10px;
            background-color:lavender; /* Light blue background */
        }

        /* Form styles */
        form {
            margin-bottom: 20px;
            text-align: center;
        }

        label {
            font-weight: bold;
        }

        input[type="text"], input[type="submit"], input[type="reset"] {
            padding: 8px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="submit"], input[type="reset"] {
            background-color: #4CAF50; /* Green submit and reset button */
            color: white;
            cursor: pointer;
            margin-left: 10px;
        }

        input[type="submit"]:hover, input[type="reset"]:hover {
            background-color: #45a049;
        }

        /* Table styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #ffffff; /* White background for table */
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2); /* Box shadow for table */
        }

        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #4CAF50; /* Dark green header */
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2; /* Light gray for even rows */
        }

        tr:hover {
            background-color: #e7e7e7; /* Light gray on hover */
        }

        /* Header style */
        h2 {
            color:darkblue; /* Dark green header text */
            text-align: center;
            font-size: 19px;
        }

        /* Message style */
        .message {
            margin-top: 20px;
            padding: 10px;
            background-color: #f44336; /* Red background for error message */
            color: white;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <h2>Ideal Tracking. </h2>
    <h2>Tracker Installation Record</h2>
    <form action="search.php" method="get">
   
        <input type="text" id="vehicle_reg" name="vehicle_reg" placeholder="Enter Vehicle REG" value="<?php echo isset($_GET['vehicle_reg']) ? htmlspecialchars($_GET['vehicle_reg']) : ''; ?>">
        <input type="submit" value="Search">
        <input type="reset" value="Reset" onclick="window.location.href='search.php';">
        <a href="dashboard.php" style="display: inline-block; padding: 10px 20px; font-size: 16px; text-decoration: none; color: #fff; background-color: #2670b9; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Home</a>

    </form>

    <?php
    // PHP script to handle search and display results
    session_start();
    if (!isset($_SESSION['username'])) {
        header("Location: login.php");
        exit();
    }
    
    $access_level = $_SESSION['access_level'];
    
    if (isset($_GET['vehicle_reg'])) {
        $vehicle_reg = $_GET['vehicle_reg'];

        include 'conn.php';
        // Prepare SQL statement to fetch vehicle details
        $sql = "SELECT * FROM record2 WHERE VEHICLE_REG = '" . $conn->real_escape_string($vehicle_reg) . "'";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            // Display results in a table
           
            echo "<table>";
            echo "<tr><th>#</th><th>Installation Date</th><th>Client Name</th><th>Sales Person</th><th>Vehicle Registration</th><th>Model</th><th>Tracker Number</th>";
            
            // Conditional display of columns based on access level
            if ($access_level !== 'Support') {
                echo "<th>Contact</th>";
                echo "<th>Username</th>";
                echo "<th>Password</th>";
            }
            
            echo "<th>Finacia</th><th>Technician</th><th>T.K</th><th>Tracksolid</th><th>Loan Duration</th><th>C/No.</th></tr>";
            
            $count = 1; // Initialize row counter
            
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $count++ . "</td>"; // Column number
                echo "<td>" . $row['INSTALLATION_DATE'] . "</td>";
                echo "<td>" . $row['CLIENT_NAME'] . "</td>";
                echo "<td>" . $row['SALES_PERSON'] . "</td>";
                echo "<td>" . $row['VEHICLE_REG'] . "</td>";
                echo "<td>" . $row['MODEL'] . "</td>";
                echo "<td>" . $row['TRACKER_NUMBER'] . "</td>";
                
                // Conditional display of columns based on access level
                if ($access_level !== 'Support') {
                    echo "<td>" . $row['CONTACT'] . "</td>";
                    echo "<td>" . $row['USERNAME'] . "</td>";
                    echo "<td>" . $row['PASSWORD'] . "</td>";
                }
                
                echo "<td>" . $row['Finacia'] . "</td>";
                echo "<td>" . $row['TECHNICIAN'] . "</td>";
                echo "<td>" . $row['T_K'] . "</td>";
                echo "<td>" . $row['Tracksolid'] . "</td>";
                echo "<td>" . $row['LOAN_DURATION'] . "</td>";
                echo "<td>" . $row['C_NO'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<div class='message'>No results found for vehicle registration number: " . htmlspecialchars($vehicle_reg) . "</div>";
        }
      
        

        // Close connection
        $conn->close();
    }
    ?>
</body>
</html>
