<?php
session_start();
include 'conn.php';


$access_level = $_SESSION['access_level'];

$search = '';
$search_field = '';
$filter = '';

// Check if a filter request is made
if (isset($_GET['filter'])) {
    $filter = $_GET['filter'];
    if ($filter === 'expired') {
        $query = "SELECT * FROM installrecord WHERE expiration_date < '" . date('Y-m-d') . "' ORDER BY date_of_installation DESC";
    } elseif ($filter === 'active') {
        $query = "SELECT * FROM installrecord WHERE expiration_date >= '" . date('Y-m-d') . "' ORDER BY date_of_installation DESC";
    }
} elseif (isset($_POST['search']) && isset($_POST['search_field'])) {
    $search = $_POST['search'];
    $search_field = $_POST['search_field'];
    $query = "SELECT * FROM installrecord WHERE " . mysqli_real_escape_string($conn, $search_field) . " LIKE '%" . mysqli_real_escape_string($conn, $search) . "%' ORDER BY date_of_installation DESC";
} else {
    $query = "SELECT * FROM installrecord ORDER BY date_of_installation DESC";
}

$result = mysqli_query($conn, $query);

$totalVehicles = mysqli_num_rows($result);
$activeVehicles = 0;
$expiredVehicles = 0;

$rows = [];

while ($row = mysqli_fetch_assoc($result)) {
    $expiration_date = isset($row['expiration_date']) ? $row['expiration_date'] : '';
    $status = '';

    if (!empty($expiration_date)) {
        $today = date('Y-m-d');
        if ($expiration_date >= $today) {
            $status = 'Active';
            $activeVehicles++;
        } else {
            $status = 'Expired';
            $expiredVehicles++;
        }
    }

    $row['status'] = $status;
    $rows[] = $row;
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View All Vehicles</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            margin: 0;
            padding: 0;
        }

        .container {
            margin: 20px auto;
            padding: 10px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            font-size: 14px;
        }

        h2 {
            color: #2670b9;
            text-align: center;
            margin-bottom: 20px;
        }

        .search-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .search-container input[type="text"],
        .search-container select {
            width: calc(30% - 20px);
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin: 0 10px;
            box-sizing: border-box;
        }

        .search-container input[type="submit"],
        .search-container input[type="button"] {
            padding: 10px 20px;
            font-size: 16px;
            border: none;
            border-radius: 5px;
            background-color: #2670b9;
            color: #fff;
            cursor: pointer;
            margin-left: 10px;
        }

        .cards-container {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
        }

        .card {
            flex: 0 1 calc(30% - 20px);
            background-color: #f0f8ff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
            text-align: center;
        }

        .card.expired {
            background-color: #ff6666;
        }

        .card h3 {
            margin-top: 0;
            color: #2670b9;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ccc;
        }

        th {
            background-color: #f0f8ff;
            font-size: 14px;
            font-weight: bold;
            text-align: center;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        tr.expired {
            background-color: #ffcccc; /* Background color for expired vehicles */
        }

        a {
            color: #2670b9;
            text-decoration: none;
            display: block;
            margin-top: 10px;
        }

        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>View All Vehicles</h2>
        <div class="search-container">
            <form method="POST" action="">
                <select name="search_field">
                    <option value="" disabled <?php if (!$search_field) echo 'selected'; ?>>Select Search Type</option>
                    <option value="vehicle_reg" <?php if ($search_field == 'vehicle_reg') echo 'selected'; ?>>Vehicle Registration</option>
                    <option value="client_name" <?php if ($search_field == 'client_name') echo 'selected'; ?>>Client Name</option>
                    <option value="tracker_number" <?php if ($search_field == 'tracker_number') echo 'selected'; ?>>Tracker Number</option>
                </select>
                <input type="text" name="search" id="search" placeholder="Enter <?php echo str_replace('_', ' ', htmlspecialchars($search_field)); ?>" value="<?php echo htmlspecialchars($search); ?>">
                <input type="submit" value="Search">
                <input type="button" value="Reset" onclick="window.location.href='view_vehicles.php'">
                <input type="button" value="Home" onclick="window.location.href='dashboard.php'">
                <span style="margin-left: 10px;">Today's Date: <?php echo date('Y-m-d'); ?></span>
            </form>
        </div>

        <div class="cards-container">
            <div class="card">
                <h3>Total Vehicles</h3>
                <p><?php echo $totalVehicles; ?></p>
            </div>
            <div class="card">
                <h3>Active Vehicles</h3>
                <p><?php echo $activeVehicles; ?></p>
                <a href="?filter=active">Filter Active Vehicles</a>
            </div>
            <div class="card expired">
                <h3>Expired Vehicles</h3>
                <p><?php echo $expiredVehicles; ?></p>
                <a href="?filter=expired">Filter Expired Vehicles</a>
            </div>
        </div>

        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date of Installation</th>
                    <th>Client Name</th>
                    <th>Sales</th>
                    <th>Vehicle Registration</th>
                    <th>Model</th>
                    <th>Tracker Number</th>
                    <?php if ($access_level !== 'Support') : ?>
                        <th>Contact</th>
                        <th>Username</th>
                        <th>Password</th>
                    <?php endif; ?>
                    <th>Financia</th>
                    <th>Technician</th>
                    <th>Gadget Sample</th>
                    <th>Type of Gadget</th>
                    <th>Loan Duration</th>
                    <th>Cert No</th>
                    <th>Expiration Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $counter = 1;
                foreach ($rows as $row) : ?>
                    <tr class="<?php echo $row['status'] === 'Expired' ? 'expired' : ''; ?>">
                        <td><?php echo $counter++; ?></td>
                        <td><?php echo htmlspecialchars($row['date_of_installation']); ?></td>
                        <td><?php echo htmlspecialchars($row['client_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['sales']); ?></td>
                        <td><?php echo htmlspecialchars($row['vehicle_reg']); ?></td>
                        <td><?php echo htmlspecialchars($row['model']); ?></td>
                        <td><?php echo htmlspecialchars($row['tracker_number']); ?></td>
                        <?php if ($access_level !== 'Support') : ?>
                            <td><?php echo htmlspecialchars($row['contact']); ?></td>
                            <td><?php echo htmlspecialchars($row['username']); ?></td>
                            <td><?php echo htmlspecialchars($row['password']); ?></td>
                        <?php endif; ?>
                        <td><?php echo htmlspecialchars($row['financia']); ?></td>
                        <td><?php echo htmlspecialchars($row['technician']); ?></td>
                        <td><?php echo htmlspecialchars($row['gadget_sample']); ?></td>
                        <td><?php echo htmlspecialchars($row['Type_of_Gadget']); ?></td>
                        <td><?php echo htmlspecialchars($row['loan_duration']); ?></td>
                        <td><?php echo htmlspecialchars($row['cert_no']); ?></td>
                        <td><?php echo htmlspecialchars($row['expiration_date']); ?></td>
                        <td><?php echo htmlspecialchars($row['status']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
