<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Records</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: lightblue;
            margin: 0;
            padding: 0;
            display: flex;
            height: 100vh;
        }
        .container {
            margin: 20px;
            padding: 10px;
            background-color: white;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .search-container {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        input[type="text"] {
            flex: 1;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            width: 50%;
        }
        input[type="submit"], input[type="button"], a.button {
            padding: 10px 20px;
            border: none;
            background-color: #007BFF;
            color: white;
            cursor: pointer;
            border-radius: 4px;
            text-decoration: none;
            text-align: center;
            display: inline-block;
        }
        input[type="submit"]:hover, input[type="button"]:hover, a.button:hover {
            background-color: #0056b3;
        }
        .cards {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
        }
        .card {
            background-color: #f2f2f2;
            padding: 20px;
            margin-left: 15px;
            border-radius: 8px;
            text-align: center;
            width: 20%;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .card a {
            display: block;
            margin-top: 10px;
            text-decoration: none;
            color: #007BFF;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .error {
            color: red;
            font-weight: bold;
            text-align: center;
            margin-top: 20px;
        }
        .expired {
            background-color: red !important;
        }
        @media (max-width: 768px) {
            .container {
                width: 90%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Search Records by Registration Number</h2>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST" id="searchForm">
            <div class="search-container">
                <input type="text" name="reg_no" id="reg_no" placeholder="Enter Registration Number" required>
                <input type="submit" value="Search">
                <input type="button" value="Reset" onclick="resetForm()">
                <a href="dashboard.php" class="button">Home</a>
            </div>
        </form>
        
        <div class="cards">
            <div class="card">
                <h3>Total Vehicles in Database</h3>
                <?php
                include 'conn.php'; // Ensure this path is correct based on your setup
                $sql_total = "SELECT COUNT(*) AS total FROM newfuel";
                $result_total = $conn->query($sql_total);
                $row_total = $result_total->fetch_assoc();
                echo "<p>" . $row_total['total'] . "</p>";
                ?>
            </div>
            <div class="card">
                <h3>Active Vehicles</h3>
                <?php
                $sql_active = "SELECT COUNT(*) AS active FROM newfuel WHERE `Expiration date` >= CURDATE()";
                $result_active = $conn->query($sql_active);
                $row_active = $result_active->fetch_assoc();
                echo "<p>" . $row_active['active'] . "</p>";
                ?>
                <a href="?filter=active">View Active Vehicles</a>
            </div>
            <div class="card">
                <h3>Expired Vehicles</h3>
                <?php
                $sql_expired = "SELECT COUNT(*) AS expired FROM newfuel WHERE `Expiration date` < CURDATE()";
                $result_expired = $conn->query($sql_expired);
                $row_expired = $result_expired->fetch_assoc();
                echo "<p>" . $row_expired['expired'] . "</p>";
                ?>
                <a href="?filter=expired">View Expired Vehicles</a>
            </div>
        </div>

        <table>
            <tr>
                <th>Installation Date</th>
                <th>Client Name</th>
                <th>Contact</th>
                <th>Registration Number</th>
                <th>Make/Model</th>
                <th>Device Type</th>
                <th>Tracker Number</th>
                <th>Technician</th>
                <th>Sales Person</th>
                <th>Login Password/Comments</th>
                <th>Location</th>
                <th>Expiration Date</th>
                <th>Status</th>
            </tr>
            <?php
            include 'conn.php'; // Ensure this path is correct based on your setup
            $sql_all_records = "SELECT *,
                                CASE 
                                    WHEN `Expiration date` < CURDATE() THEN 'Expired'
                                    ELSE 'Active'
                                END AS status
                                FROM newfuel";

            // Check if filter is set
            if (isset($_GET['filter'])) {
                $filter = $_GET['filter'];
                if ($filter === 'active') {
                    $sql_all_records .= " WHERE `Expiration date` >= CURDATE()";
                } elseif ($filter === 'expired') {
                    $sql_all_records .= " WHERE `Expiration date` < CURDATE()";
                }
            }

            // Check if form is submitted for search
            if ($_SERVER["REQUEST_METHOD"] == "POST") {
                $reg_no = $conn->real_escape_string($_POST['reg_no']);
                $sql_all_records .= " WHERE `REG NO` LIKE '%$reg_no%'";
            }

            $result_all_records = $conn->query($sql_all_records);

            if ($result_all_records->num_rows > 0) {
                while ($row = $result_all_records->fetch_assoc()) {
                    $status = $row['status'];
                    $rowClass = $status == 'Expired' ? 'class="expired"' : '';
                    echo "<tr $rowClass>
                            <td>" . $row['INSTALLATION DATE'] . "</td>
                            <td>" . $row['Client Name'] . "</td>
                            <td>" . $row['CONTACT'] . "</td>
                            <td>" . $row['REG NO'] . "</td>
                            <td>" . $row['MAKE/MODEL'] . "</td>
                            <td>" . $row['DEVICE TYPE'] . "</td>
                            <td>" . $row['TRACKER NO'] . "</td>
                            <td>" . $row['TECHNICIAN'] . "</td>
                            <td>" . $row['SALES PERSON'] . "</td>
                            <td>" . $row['LOGIN PASSWORD/COMMENTS'] . "</td>
                            <td>" . $row['LOCATION'] . "</td>
                            <td>" . $row['Expiration date'] . "</td>
                            <td>" . $row['status'] . "</td>
                          </tr>";
                }
            } else {
                echo "<tr><td colspan='13' class='error'>No records found.</td></tr>";
            }

            $conn->close();
            ?>
        </table>

    </div>

    <script>
        function resetForm() {
            document.getElementById("searchForm").reset(); // Reset the form
            location.reload(); // Reload the page
        }
    </script>
</body>
</html>
