<?php
session_start();

// Check if logout is requested
if (isset($_GET['logout'])) {
    // Unset all session variables
    $_SESSION = array();

    // Destroy the session
    session_destroy();

    // Redirect to the login page
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        /* Reset default styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* Basic styling */
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            overflow-x: hidden;
        }

        .sidebar {
            width: 250px; /* Default width for larger screens */
            height: 100vh;
            background-color: #2980b9;
            color: #fff;
            position: fixed;
            top: 0;
            left: 0;
            overflow-x: hidden;
            transition: width 0.3s ease;
            z-index: 1000;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
        }

        .sidebar.active {
            width: 100vw; /* Full width for the sidebar */
        }

        .sidebar-header {
            text-align: center;
            padding: 20px 0;
            border-bottom: 2px solid #1f618d;
            color: #ecf0f1;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .sidebar-header .clock {
            font-size: 2rem;
        }

        .sidebar-menu {
            list-style-type: none;
            padding: 0;
        }

        .sidebar-menu li {
            position: relative;
        }

        .sidebar-menu li a {
            color: #fff;
            text-decoration: none;
            display: flex;
            align-items: center;
            padding: 15px 20px;
            transition: background-color 0.3s ease;
            font-size: 1rem;
        }

        .sidebar-menu li a:hover {
            background-color: #1f618d;
            border-left: 5px solid #fff;
        }

        .icon {
            margin-right: 15px;
            font-size: 1.2rem;
        }

        .sidebar-dropdown .sub-menu {
            display: none;
            position: absolute;
            left: 0;
            background-color: #1f618d;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            z-index: 999;
            padding: 10px 0;
            width: 100%;
        }

        .sidebar-dropdown:hover .sub-menu {
            display: block;
        }

        .sub-menu li a {
            padding: 10px 20px;
            color: #d5dbdb;
            font-size: 0.9rem;
        }

        .sub-menu li a:hover {
            background-color: #2c3e50;
        }

        .main-content {
            margin-left: 250px; /* Default margin for larger screens */
            padding: 20px;
            box-sizing: border-box;
            background: url('ideallogo.jpeg') no-repeat center center;
            background-size: auto 80%;
            height: 100vh;
            overflow-y: auto;
            transition: margin-left 0.3s ease;
            background-color: #ffffff;
        }

        .hamburger {
            display: none;
            font-size: 1.5rem;
            color: #fff;
            background: #2980b9;
            padding: 10px;
            cursor: pointer;
            position: fixed;
            top: 10px;
            right: 10px;
            z-index: 1001;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        .hamburger:hover {
            background-color: #1f618d;
        }

        .user-icon {
            margin: 20px auto;
            text-align: center;
        }

        .user-icon i {
            font-size: 2.5rem;
            color: #fff;
        }

        .welcome-message {
            text-align: center;
            margin-bottom: 20px;
        }

        .welcome-message h4 {
            margin: 0;
            font-size: 1.2rem;
            color: #d5dbdb;
        }

        /* Responsive styles */
        @media screen and (max-width: 768px) {
            .sidebar {
                width: 0;
            }

            .sidebar.active {
                width: 100vw;
            }

            .main-content {
                margin-left: 0;
            }

            .hamburger {
                display: block;
            }

            .user-icon i {
                font-size: 2rem;
            }

            .welcome-message h4 {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="hamburger" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <div class="sidebar">
        <div class="sidebar-header">
            <div id="clock" class="clock"></div>
        </div>
        <div class="user-icon">
            <i class="fas fa-user-circle"></i>
        </div>
        <div class="welcome-message">
            <?php
            if(isset($_SESSION['username'])) {
                $username = htmlspecialchars($_SESSION['username']);
                echo '<h4>Welcome, '.$username.'</h4>';
            }
            ?>
        </div>
        <ul class="sidebar-menu">
            <?php
            if(isset($_SESSION['username']) && isset($_SESSION['access_level'])) {
                $username = $_SESSION['username'];
                $access_level = $_SESSION['access_level'];

                // Logout menu item
                echo '<li><a href="?logout"><i class="fas fa-sign-out-alt icon"></i>Logout</a></li>';
                     echo '<li><a href="https://cert.idealtracking.co.ke/"><i class="fas fa-certificate icon"></i>Generate Certificate</a></li>';

                // Full access for MD
                if ($access_level === 'MD') {
                    // Fuel section with hover dropdown
                    echo '<li class="sidebar-dropdown">';
                    echo '<a href="#"><i class="fas fa-gas-pump icon"></i>Fuel <i class="fas fa-chevron-down"></i></a>';
                    echo '<ul class="sub-menu">';
                    echo '<li><a href="oldfuel.php"><i class="fas fa-file-alt icon"></i>Manual Fuel Record</a></li>';
                    echo '<li><a href="insert_newfuel.php"><i class="fas fa-file-alt icon"></i>Add Fuel Record</a></li>';
                    echo '<li><a href="autofuelsearch.php"><i class="fas fa-file-alt icon"></i>Ideal Fuel Records</a></li>';
                    echo '</ul></li>';

                    // Trackers section with hover dropdown
                    echo '<li class="sidebar-dropdown">';
                    echo '<a href="#"><i class="fas fa-clipboard-list icon"></i>Trackers <i class="fas fa-chevron-down"></i></a>';
                    echo '<ul class="sub-menu">';
                    echo '<li><a href="expiraysort.php"><i class="fas fa-search icon"></i>Search Tracker Record</a></li>';
                    echo '<li><a href="record10upload.php"><i class="fas fa-upload icon"></i>Add Tracker Record</a></li>';
                    echo '<li><a href="record10delete.php"><i class="fas fa-trash-alt icon"></i>Delete Tracker Record</a></li>';
                    echo '<li><a href="record10update.php"><i class="fas fa-pencil-alt icon"></i>Edit Tracker Record</a></li>';
                    echo '<li><a href="record10renew.php"><i class="fas fa-sync-alt icon"></i>Do Renewals</a></li>';
                    echo '<li><a href="renewals.php"><i class="fas fa-database icon"></i>Renewal Database</a></li>';
                    echo '</ul></li>';

                    // Actions section with hover dropdown
                    echo '<li class="sidebar-dropdown">';
                    echo '<a href="#"><i class="fas fa-tasks icon"></i>Actions <i class="fas fa-chevron-down"></i></a>';
                    echo '<ul class="sub-menu">';
                    echo '<li><a href="insert_user.php"><i class="fas fa-user-plus icon"></i>Add New User</a></li>';
                    echo '<li><a href="manage_technicians.php"><i class="fas fa-tools icon"></i>Add Technician</a></li>';
                    echo '<li><a href="manage_sales_persons.php"><i class="fas fa-user-tag icon"></i>Add Sales Person</a></li>';
                    echo '</ul></li>';
                } elseif ($access_level === 'ADMIN') {
                    // Fuel section with hover dropdown
                    echo '<li class="sidebar-dropdown">';
                    echo '<a href="#"><i class="fas fa-gas-pump icon"></i>Fuel <i class="fas fa-chevron-down"></i></a>';
                    echo '<ul class="sub-menu">';
                    echo '<li><a href="oldfuel.php"><i class="fas fa-file-alt icon"></i>Google Docs Fuel Record</a></li>';
                    echo '<li><a href="insert_newfuel.php"><i class="fas fa-file-alt icon"></i>Add Fuel Record</a></li>';
                    echo '<li><a href="autofuelsearch.php"><i class="fas fa-file-alt icon"></i>Ideal Fuel Records</a></li>';
                    echo '</ul></li>';

                    // Trackers section with hover dropdown
                    echo '<li class="sidebar-dropdown">';
                    echo '<a href="#"><i class="fas fa-clipboard-list icon"></i>Trackers <i class="fas fa-chevron-down"></i></a>';
                    echo '<ul class="sub-menu">';
                    echo '<li><a href="expiraysort.php"><i class="fas fa-search icon"></i>Search Tracker Record</a></li>';
                    echo '<li><a href="record10upload.php"><i class="fas fa-upload icon"></i>Add Tracker Record</a></li>';
                    echo '<li><a href="record10delete.php"><i class="fas fa-trash-alt icon"></i>Delete Tracker Record</a></li>';
                    echo '<li><a href="record10update.php"><i class="fas fa-pencil-alt icon"></i>Edit Tracker Record</a></li>';
                    echo '<li><a href="record10renew.php"><i class="fas fa-sync-alt icon"></i>Do Renewals</a></li>';
                    echo '<li><a href="renewals.php"><i class="fas fa-database icon"></i>Renewal Database</a></li>';
                    echo '</ul></li>';

                    // Actions section with hover dropdown
                    echo '<li class="sidebar-dropdown">';
                    echo '<a href="#"><i class="fas fa-tasks icon"></i>Actions <i class="fas fa-chevron-down"></i></a>';
                    echo '<ul class="sub-menu">';
                    echo '<li><a href="manage_technicians.php"><i class="fas fa-tools icon"></i>Add Technician</a></li>';
                    echo '<li><a href="manage_sales_persons.php"><i class="fas fa-user-tag icon"></i>Add Sales Person</a></li>';
                    echo '</ul></li>';
                } elseif ($access_level === 'SUPPORT') {
                    echo '<li><a href="expiraysort.php"><i class="fas fa-search icon"></i>Search Tracker Record</a></li>';
                    
                } else {
                    echo '<li><a href="index.php"><i class="fas fa-home icon"></i>Home</a></li>';
                }
            } else {
                echo '<li><a href="index.php"><i class="fas fa-home icon"></i>Home</a></li>';
            }
            ?>
        </ul>
    </div>
    <div class="main-content">
        <h1 style="text-align: center; color: #2c3e50;">IDT SYSTEM</h1>
        <p style="text-align: center; color: #34495e;"></p>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            sidebar.classList.toggle('active');
        }

        function updateClock() {
            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');
            const clockElement = document.getElementById('clock');
            clockElement.textContent = `${hours}:${minutes}:${seconds}`;
        }

        setInterval(updateClock, 1000);
        updateClock(); // Initialize clock immediately
    </script>
</body>
</html>
