<?php
// Include database connection file
include 'conn.php';

// Initialize variables
$vehicle_reg = "";
$record = null;
$message = "";
$messageClass = "";

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['search'])) {
    if (isset($_POST['vehicle_reg'])) {
        // Escape user input for security
        $vehicle_reg = mysqli_real_escape_string($conn, $_POST['vehicle_reg']);

        // Query to fetch the record
        $query = "SELECT * FROM installrecord WHERE vehicle_reg = '$vehicle_reg'";
        $result = mysqli_query($conn, $query);

        if ($result && mysqli_num_rows($result) > 0) {
            // Fetch record details
            $record = mysqli_fetch_assoc($result);
        } else {
            $message = "No record found for Vehicle Registration Number '$vehicle_reg'";
            $messageClass = "error";
        }
    }
}

// Handle delete confirmation
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete'])) {
    if (isset($_POST['vehicle_reg'])) {
        // Escape user input for security
        $vehicle_reg = mysqli_real_escape_string($conn, $_POST['vehicle_reg']);

        // Delete query
        $deleteQuery = "DELETE FROM installrecord WHERE vehicle_reg = '$vehicle_reg'";
        if (mysqli_query($conn, $deleteQuery)) {
            $message = "Record deleted successfully";
            $messageClass = "success";
            $record = null; // Clear the record details
        } else {
            $message = "Error deleting record: " . mysqli_error($conn);
            $messageClass = "error";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Installation Record</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f8ff;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background-color: #e6f7ff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 800px;
            width: 100%;
            box-sizing: border-box;
            margin-top: 30px;
        }
        h2 {
            color: #007acc;
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        label {
            color: #007acc;
            margin-bottom: 5px;
        }
        input[type="text"], button {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        button {
            background-color: #007acc;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #005fa3;
        }
        .record-details {
            background-color: #ffffff;
            padding: 15px;
            border: 1px solid #007acc;
            border-radius: 5px;
        }
        .message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background-color: #dff0d8; /* Success message background color */
            border: 1px solid #3c763d; /* Success message border color */
            color: #3c763d; /* Success message text color */
            border-radius: 5px;
            display: none; /* Initially hidden */
            z-index: 9999; /* Ensure it's on top */
        }
        .message.error {
            background-color: #f2dede; /* Error message background color */
            border-color: #a94442; /* Error message border color */
            color: #a94442; /* Error message text color */
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Delete Installation Record</h2>
        <!-- Form to enter vehicle registration number -->
        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
            <label for="vehicle_reg">Enter Vehicle Registration Number:</label>
            <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>" required>
            <button type="submit" name="search">Search Record</button>
        </form>

        <!-- Display record details if found -->
        <?php if ($record) : ?>
            <div class="record-details">
                <h3>Record Details</h3>
                <p><strong>Vehicle Reg:</strong> <?php echo htmlspecialchars($record['vehicle_reg']); ?></p>
                <p><strong>Installation Date:</strong> <?php echo isset($record['installation_date']) ? htmlspecialchars($record['installation_date']) : 'N/A'; ?></p>
                <p><strong>Client Name:</strong> <?php echo isset($record['client_name']) ? htmlspecialchars($record['client_name']) : 'N/A'; ?></p>
                <p><strong>Sales Person:</strong> <?php echo isset($record['sales_person']) ? htmlspecialchars($record['sales_person']) : 'N/A'; ?></p>
                <p><strong>Model:</strong> <?php echo isset($record['model']) ? htmlspecialchars($record['model']) : 'N/A'; ?></p>
                <p><strong>Tracker Number:</strong> <?php echo isset($record['tracker_number']) ? htmlspecialchars($record['tracker_number']) : 'N/A'; ?></p>
                <p><strong>Contact:</strong> <?php echo isset($record['contact']) ? htmlspecialchars($record['contact']) : 'N/A'; ?></p>
                <p><strong>Finacia:</strong> <?php echo isset($record['finacia']) ? htmlspecialchars($record['finacia']) : 'N/A'; ?></p>
                <p><strong>Technician:</strong> <?php echo isset($record['technician']) ? htmlspecialchars($record['technician']) : 'N/A'; ?></p>
                <p><strong>T.K:</strong> <?php echo isset($record['t_k']) ? htmlspecialchars($record['t_k']) : 'N/A'; ?></p>
                <p><strong>Tracksolid:</strong> <?php echo isset($record['tracksolid']) ? htmlspecialchars($record['tracksolid']) : 'N/A'; ?></p>
                <p><strong>Username:</strong> <?php echo isset($record['username']) ? htmlspecialchars($record['username']) : 'N/A'; ?></p>
                <p><strong>Password:</strong> <?php echo isset($record['password']) ? htmlspecialchars($record['password']) : 'N/A'; ?></p>
                <p><strong>Loan Duration:</strong> <?php echo isset($record['loan_duration']) ? htmlspecialchars($record['loan_duration']) : 'N/A'; ?></p>
                <p><strong>C/NO:</strong> <?php echo isset($record['c_no']) ? htmlspecialchars($record['c_no']) : 'N/A'; ?></p>
                <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                    <input type="hidden" name="vehicle_reg" value="<?php echo htmlspecialchars($record['vehicle_reg']); ?>">
                    <button type="submit" name="delete">Confirm Delete</button>
                </form>
            </div>
        <?php endif; ?>

        <!-- Display success or error message -->
        <?php if (!empty($message)) : ?>
            <div class="message <?php echo $messageClass; ?>" id="message">
                <?php echo $message; ?>
            </div>
            <script>
                // Show the message for 3 seconds and then hide it
                setTimeout(function() {
                    document.getElementById('message').style.display = 'none';
                }, 3000);
            </script>
        <?php endif; ?>
    </div>
</body>
</html>
