<?php
// Include database connection file
include 'conn.php';

// Initialize variables
$vehicle_reg = "";
$new_vehicle_reg = "";
$date_of_installation = "";
$client_name = "";
$sales = "";
$model = "";
$tracker_number = "";
$contact = "";
$financia = "";
$technician = "";
$gadget_sample = "";
$type_of_gadget = "";
$username = "";
$password = "";
$loan_duration = "";
$cert_no = "";
$message = "";
$messageClass = "";

// Fetch options for select fields
$querySales = "SELECT DISTINCT sales FROM installrecord";
$resultSales = mysqli_query($conn, $querySales);

$queryGadgets = "SELECT DISTINCT type_of_gadget FROM installrecord";
$resultGadgets = mysqli_query($conn, $queryGadgets);

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['vehicle_reg']) && !isset($_POST['update_record'])) {
        // Escape user input for security
        $vehicle_reg = mysqli_real_escape_string($conn, $_POST['vehicle_reg']);

        // Query to retrieve installation record
        $query = "SELECT * FROM installrecord WHERE vehicle_reg = '$vehicle_reg'";
        $result = mysqli_query($conn, $query);

        if ($result) {
            if (mysqli_num_rows($result) > 0) {
                // Fetch record details
                $row = mysqli_fetch_assoc($result);
                $date_of_installation = $row['date_of_installation'];
                $client_name = $row['client_name'];
                $sales = $row['sales'];
                $model = $row['model'];
                $tracker_number = $row['tracker_number'];
                $contact = $row['contact'];
                $financia = $row['financia'];
                $technician = $row['technician'];
                $gadget_sample = $row['gadget_sample'];
                $type_of_gadget = isset($row['type_of_gadget']) ? $row['type_of_gadget'] : "";
                $username = $row['username'];
                $password = $row['password'];
                $loan_duration = $row['loan_duration'];
                $cert_no = $row['cert_no'];
            } else {
                $message = "Error: No record found for Vehicle Registration Number '$vehicle_reg'";
                $messageClass = "error";
            }
        } else {
            $message = "Error: " . mysqli_error($conn);
            $messageClass = "error";
        }
    } elseif (isset($_POST['update_record'])) {
        // Escape user inputs for security
        $vehicle_reg = mysqli_real_escape_string($conn, $_POST['vehicle_reg']);
        $new_vehicle_reg = mysqli_real_escape_string($conn, $_POST['new_vehicle_reg']);
        $date_of_installation = mysqli_real_escape_string($conn, $_POST['date_of_installation']);
        $client_name = mysqli_real_escape_string($conn, $_POST['client_name']);
        $sales = mysqli_real_escape_string($conn, $_POST['sales']);
        $model = mysqli_real_escape_string($conn, $_POST['model']);
        $tracker_number = mysqli_real_escape_string($conn, $_POST['tracker_number']);
        $contact = mysqli_real_escape_string($conn, $_POST['contact']);
        $financia = mysqli_real_escape_string($conn, $_POST['financia']);
        $technician = mysqli_real_escape_string($conn, $_POST['technician']);
        $gadget_sample = mysqli_real_escape_string($conn, $_POST['gadget_sample']);
        $type_of_gadget = mysqli_real_escape_string($conn, $_POST['type_of_gadget']);
        $username = mysqli_real_escape_string($conn, $_POST['username']);
        $password = mysqli_real_escape_string($conn, $_POST['password']);
        $loan_duration = mysqli_real_escape_string($conn, $_POST['loan_duration']);
        $cert_no = mysqli_real_escape_string($conn, $_POST['cert_no']);

        // Update query
        $updateQuery = "UPDATE installrecord SET 
                        vehicle_reg = '$new_vehicle_reg',
                        date_of_installation = '$date_of_installation',
                        client_name = '$client_name',
                        sales = '$sales',
                        model = '$model',
                        tracker_number = '$tracker_number',
                        contact = '$contact',
                        financia = '$financia',
                        technician = '$technician',
                        gadget_sample = '$gadget_sample',
                        type_of_gadget = '$type_of_gadget',
                        username = '$username',
                        password = '$password',
                        loan_duration = '$loan_duration',
                        cert_no = '$cert_no'
                        WHERE vehicle_reg = '$vehicle_reg'";

        if (mysqli_query($conn, $updateQuery)) {
            $message = "Record updated successfully";
            $messageClass = "success";
        } else {
            $message = "Error updating record: " . mysqli_error($conn);
            $messageClass = "error";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Installation Record</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f8ff;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background-color: #e6f7ff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 800px;
            width: 100%;
            box-sizing: border-box;
            margin-top: 30px;
        }
        h2 {
            color: #007acc;
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        label {
            color: #007acc;
            margin-bottom: 5px;
        }
        input[type="text"], input[type="date"], input[type="number"], input[type="password"], select {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        .full-width {
            width: 100%;
        }
        button {
            width: 100%;
            padding: 10px;
            background-color: #007acc;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #005fa3;
        }
        .message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background-color: #dff0d8; /* Success message background color */
            border: 1px solid #3c763d; /* Success message border color */
            color: #3c763d; /* Success message text color */
            border-radius: 5px;
            display: none; /* Initially hidden */
            z-index: 9999; /* Ensure it's on top */
        }
        .message.error {
            background-color: #f2dede; /* Error message background color */
            border-color: #a94442; /* Error message border color */
            color: #a94442; /* Error message text color */
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Edit Installation Record</h2>
        <?php if (empty($vehicle_reg) || !empty($message)) : ?>
            <!-- Form to enter vehicle registration number -->
            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <label for="vehicle_reg">Enter Vehicle Registration Number:</label>
                <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>" required>
                <button type="submit">Submit</button>
            </form>
        <?php elseif (!empty($vehicle_reg)) : ?>
            <!-- Form filled with details -->
            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <div class="form-group">
                    <label for="vehicle_reg">Current Vehicle Registration</label>
                    <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>" readonly>
                </div>
                <div class="form-group">
                    <label for="new_vehicle_reg">New Vehicle Registration</label>
                    <input type="text" id="new_vehicle_reg" name="new_vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>" required>
                </div>
                <div class="form-group">
                    <label for="date_of_installation">Date of Installation</label>
                    <input type="date" id="date_of_installation" name="date_of_installation" value="<?php echo htmlspecialchars($date_of_installation); ?>" required>
                </div>
                <div class="form-group">
                    <label for="client_name">Client Name</label>
                    <input type="text" id="client_name" name="client_name" value="<?php echo htmlspecialchars($client_name); ?>" required>
                </div>
                <div class="form-group">
                    <label for="sales">Sales</label>
                    <select id="sales" name="sales" required>
                        <option value="" disabled>Select Sales</option>
                        <?php
                        if ($resultSales) {
                            while ($row = mysqli_fetch_assoc($resultSales)) {
                                $selected = ($sales == $row['sales']) ? 'selected' : '';
                                echo '<option value="' . $row['sales'] . '" ' . $selected . '>' . $row['sales'] . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="model">Model</label>
                    <input type="text" id="model" name="model" value="<?php echo htmlspecialchars($model); ?>" required>
                </div>
                <div class="form-group">
                    <label for="tracker_number">Tracker Number</label>
                    <input type="text" id="tracker_number" name="tracker_number" value="<?php echo htmlspecialchars($tracker_number); ?>" required>
                </div>
                <div class="form-group">
                    <label for="contact">Contact</label>
                    <input type="text" id="contact" name="contact" value="<?php echo htmlspecialchars($contact); ?>" required>
                </div>
                <div class="form-group">
                    <label for="financia">Financia</label>
                    <input type="text" id="financia" name="financia" value="<?php echo htmlspecialchars($financia); ?>" required>
                </div>
                <div class="form-group">
                    <label for="technician">Technician</label>
                    <input type="text" id="technician" name="technician" value="<?php echo htmlspecialchars($technician); ?>" required>
                </div>
                <div class="form-group">
                    <label for="gadget_sample">Gadget Sample</label>
                    <input type="text" id="gadget_sample" name="gadget_sample" value="<?php echo htmlspecialchars($gadget_sample); ?>" required>
                </div>
                <div class="form-group">
                    <label for="type_of_gadget">Type of Gadget</label>
                    <select id="type_of_gadget" name="type_of_gadget" required>
                        <option value="" disabled>Select Type of Gadget</option>
                        <?php
                        if ($resultGadgets) {
                            while ($row = mysqli_fetch_assoc($resultGadgets)) {
                                $selected = ($type_of_gadget == $row['type_of_gadget']) ? 'selected' : '';
                                echo '<option value="' . $row['type_of_gadget'] . '" ' . $selected . '>' . $row['type_of_gadget'] . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
                </div>
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" value="<?php echo htmlspecialchars($password); ?>" required>
                </div>
                <div class="form-group">
                    <label for="loan_duration">Loan Duration</label>
                    <input type="number" id="loan_duration" name="loan_duration" value="<?php echo htmlspecialchars($loan_duration); ?>" required>
                </div>
                <div class="form-group">
                    <label for="cert_no">Certificate Number</label>
                    <input type="text" id="cert_no" name="cert_no" value="<?php echo htmlspecialchars($cert_no); ?>" required>
                </div>
                <input type="hidden" name="update_record" value="1">
                <button type="submit">Update Record</button>
            </form>
        <?php endif; ?>
        <!-- Display success or error message -->
        <?php if (!empty($message)) : ?>
            <div class="message <?php echo $messageClass; ?>" id="message">
                <?php echo $message; ?>
            </div>
            <script>
                // Show the message for 3 seconds and then hide it
                setTimeout(function() {
                    document.getElementById('message').style.display = 'none';
                }, 3000);
            </script>
        <?php endif; ?>
    </div>
</body>
</html>
