<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>IDT SYSTEM</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: blueviolet;
            color: #333;
            padding: 0;
            margin: 0;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        h2 {
            text-align: center;
            color: #fff;
            margin-bottom: 30px;
        }

        form {
            margin-bottom: 80px; /* Space for the fixed horizontal scrollbar */
            background-color: rgba(255, 255, 255, 0.9);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            justify-content: space-around;
        }

        .form-group {
            display: flex;
            flex-basis: 48%;
            align-items: center;
            gap: 10px;
            margin: 10px 0;
        }

        .form-group label {
            flex-basis: 40%;
            text-align: right;
            color: #004e92;
        }

        .form-group input, .form-group select {
            flex-basis: 60%;
            padding: 8px;
            border-radius: 5px;
            border: 1px solid #004e92;
        }

        input[type="submit"] {
            padding: 8px 15px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        input[type="submit"]:hover {
            background-color: #0056b3;
        }

        .table-container {
            width: 100%;
            height: calc(100vh - 100px); /* Adjust the height to fit within the viewport */
            overflow: auto;
            position: relative;
            background-color: #fff;
            border-top: 1px solid #ddd;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            font-size: 12px;
        }

        th, td {
            padding: 8px 10px;
            text-align: left;
            border: 1px solid #ddd;
            white-space: nowrap; /* Prevent text wrapping */
        }

        thead th {
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            background-color: #f9f9f9;
            z-index: 10;
        }

        .expired {
            background-color: #B22222;
            color: white;
        }

        .zero-loan {
            background-color: #cce5ff; /* Light blue background for zero or empty loan duration */
            color: #004e92; /* Dark blue text for contrast */
        }

        .print-button {
            margin-top: 20px;
            display: block;
            width: 200px;
            padding: 8px;
            font-size: 14px;
            text-align: center;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .print-button:hover {
            background-color: #0056b3;
        }

        .nav-bar {
            position: fixed;
            bottom: 0;
            width: 100%;
            background-color: #333;
            color: #fff;
            text-align: center;
            padding: 10px 0;
            box-shadow: 0 -2px 5px rgba(0, 0, 0, 0.2);
        }

        .nav-bar a {
            color: #fff;
            text-decoration: none;
            margin: 0 10px;
            font-size: 16px;
            transition: color 0.3s ease;
        }

        .nav-bar a:hover {
            color: #007bff;
        }

       @media print {
    form {
        display: none; /* Hide the form when printing */
    }
    .nav-bar {
        display: none; /* Hide the navigation bar when printing */
    }
    .print-button {
        display: none; /* Hide the print button when printing */
    }
    table {
        width: 100%;
        border-collapse: collapse;
        background-color: transparent !important; /* Preserve background color */
        color: black !important; /* Ensure text color is black */
        page-break-inside: auto; /* Avoid breaking inside table rows */
        font-size: 10px; /* Adjust font size for printing */
    }
    thead {
        display: table-header-group; /* Ensure header is repeated on each page */
    }
    tbody {
        display: table-row-group;
    }
    tr {
        page-break-inside: auto;
        page-break-after: auto;
    }
    th, td {
        padding: 5px; /* Adjust padding for printing */
    }
}

        @media (max-width: 768px) {
            .form-group {
                flex-basis: 100%;
                flex-direction: column;
                align-items: flex-start;
            }
            .form-group label {
                text-align: left;
                flex-basis: 100%;
            }
            .form-group input, .form-group select {
                flex-basis: 100%;
            }
        }
    </style>
</head>
<body>
    <h2>Ideal Tracking, Trackers Record</h2>

    <form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post">
        <div class="form-group">
            <label for="salesPerson">Sales Person:</label>
            <select id="salesPerson" name="salesPerson">
                <option value="">Select Sales Person</option>
                <?php
                // Database connection details
                $dbHost = 'localhost';
                $dbName = 'rantovpw_idealtrackrecord';
                $dbUser = 'rantovpw_idealtrack';
                $dbPass = 'P?YjNx%N[XGp';

                // Connect to the database
                $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

                // Check connection
                if ($conn->connect_error) {
                    die("Connection failed: " . $conn->connect_error);
                }

                // Fetch sales persons
                $salesPersonQuery = "SELECT DISTINCT SALES_PERSON FROM record10";
                $salesPersonResult = $conn->query($salesPersonQuery);

                if ($salesPersonResult->num_rows > 0) {
                    while($row = $salesPersonResult->fetch_assoc()) {
                        echo '<option value="' . htmlspecialchars($row['SALES_PERSON']) . '">' . htmlspecialchars($row['SALES_PERSON']) . '</option>';
                    }
                }

                // Close the connection
                $conn->close();
                ?>
            </select>
        </div>
        <div class="form-group">
            <label for="startDate">Start Date:</label>
            <input type="date" id="startDate" name="startDate">
        
            <label for="endDate">End Date:</label>
            <input type="date" id="endDate" name="endDate">
        </div>
        <div class="form-group">
            <label for="clientName">Client Name:</label>
            <input type="text" id="clientName" name="clientName">
        </div>
        <div class="form-group">
            <label for="bank">Bank:</label>
            <input type="text" id="bank" name="bank">
        </div>
        <div class="form-group">
            <label for="vehicleReg">Vehicle Registration:</label>
            <input type="text" id="vehicleReg" name="vehicleReg">
        </div>
        <input type="submit" value="Generate Report" name="submit">
        <a href="dashboard.php" style="display: inline-block; padding: 8px 15px; font-size: 14px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
    </form>

    <?php
    // Function to format date for SQL comparison
    function formatDate($date) {
        return date('m/d/Y', strtotime($date));
    }

    if (isset($_POST['submit'])) {
        // Database connection details
        $dbHost = 'localhost';
        $dbName = 'rantovpw_idealtrackrecord';
        $dbUser = 'rantovpw_idealtrack';
        $dbPass = 'P?YjNx%N[XGp';

        // Connect to the database
        $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Sanitize input data
        function sanitize($data, $conn) {
            return mysqli_real_escape_string($conn, trim($data));
        }

        $conditions = [];

        // Apply filters based on form input
        if (!empty($_POST['salesPerson'])) {
            $salesPerson = sanitize($_POST['salesPerson'], $conn);
            $conditions[] = "SALES_PERSON = '$salesPerson'";
        }

        if (!empty($_POST['startDate']) && !empty($_POST['endDate'])) {
            $startDate = formatDate($_POST['startDate']);
            $endDate = formatDate($_POST['endDate']);
            $conditions[] = "STR_TO_DATE(INSTALLATION_DATE, '%m/%d/%Y') BETWEEN STR_TO_DATE('$startDate', '%m/%d/%Y') AND STR_TO_DATE('$endDate', '%m/%d/%Y')";
        }

        if (!empty($_POST['clientName'])) {
            $clientName = sanitize($_POST['clientName'], $conn);
            $conditions[] = "CLIENT_NAME LIKE '%$clientName%'";
        }

        if (!empty($_POST['bank'])) {
            $bank = sanitize($_POST['bank'], $conn);
            $conditions[] = "Bank LIKE '%$bank%'";
        }

        if (!empty($_POST['vehicleReg'])) {
            $vehicleReg = sanitize($_POST['vehicleReg'], $conn);
            $conditions[] = "VEHICLE_REG LIKE '%$vehicleReg%'";
        }

        $sql = "SELECT * FROM record10 WHERE 1=1";
        
        if (!empty($conditions)) {
            $sql .= " AND " . implode(" AND ", $conditions);
        }

        $sql .= " ORDER BY STR_TO_DATE(INSTALLATION_DATE, '%m/%d/%Y') DESC";

        $result = $conn->query($sql);

        if (!$result) {
            die("Error executing query: " . $conn->error);
        }

        if ($result->num_rows > 0) {
            echo '<div class="table-container">';
            echo '<table>';
            echo '<thead><tr><th>S/N</th><th>INSTALLATION_DATE</th><th>CLIENT_NAME</th><th>SALES_PERSON</th><th>VEHICLE_REG</th><th>MODEL</th><th>TRACKER_NUMBER</th><th>CONTACT</th><th>Bank</th><th>USERNAME</th><th>PASSWORD</th><th>LOAN_DURATION</th><th>C_NO</th><th>Expiry</th><th>TECHNICIAN</th><th>T_K</th><th>Tracksolid</th></tr></thead>';
            echo '<tbody>';
            $serialNumber = 1;
            $currentDate = new DateTime();
            while ($row = $result->fetch_assoc()) {
                $expiryDate = DateTime::createFromFormat('m/d/Y', $row['expiray']);
                $isExpired = ($expiryDate && $currentDate > $expiryDate);

                $loanDuration = isset($row['LOAN_DURATION']) ? $row['LOAN_DURATION'] : '';
                $isZeroOrEmptyLoan = (empty($loanDuration) || $loanDuration === '0');

                $rowClass = '';
                if ($isZeroOrEmptyLoan) {
                    $rowClass = 'zero-loan'; // Apply bluish color for zero or empty loan duration
                } elseif ($isExpired) {
                    $rowClass = 'expired'; // Apply red color for expired rows
                }

                echo "<tr class='$rowClass'>";
                echo "<td>" . $serialNumber . "</td>";
                echo "<td>" . $row["INSTALLATION_DATE"] . "</td>";
                echo "<td>" . $row["CLIENT_NAME"] . "</td>";
                echo "<td>" . $row["SALES_PERSON"] . "</td>";
                echo "<td>" . $row["VEHICLE_REG"] . "</td>";
                echo "<td>" . $row["MODEL"] . "</td>";
                echo "<td>" . $row["TRACKER_NUMBER"] . "</td>";
                echo "<td>" . $row["CONTACT"] . "</td>";
                echo "<td>" . $row["Bank"] . "</td>";
                echo "<td>" . $row["USERNAME"] . "</td>";
                echo "<td>" . $row["PASSWORD"] . "</td>";
                echo "<td>" . $row["LOAN_DURATION"] . "</td>";
                echo "<td>" . $row["C_NO"] . "</td>";
                echo "<td>" . $row["expiray"] . "</td>";
                echo "<td>" . $row["TECHNICIAN"] . "</td>";
                echo "<td>" . $row["T_K"] . "</td>";
                echo "<td>" . $row["Tracksolid"] . "</td>";
                echo "</tr>";
                $serialNumber++;
            }
            echo '</tbody>';
            echo '</table>';
            echo '</div>';

            echo '<button class="print-button" onclick="window.print()">Print Report</button>';
        } else {
            echo '<p style="text-align: center; color: white;">No records found.</p>';
        }

        $conn->close();
    }
    ?>

    
    
</body>
</html>
