<?php
// Database connection parameters
$dbHost = 'localhost';
$dbName = 'rantovpw_idealtrackrecord';
$dbUser = 'rantovpw_idealtrack';
$dbPass = 'P?YjNx%N[XGp';

// Connect to the database
$conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// SQL query to retrieve all records
$sql = "SELECT * FROM record10";
$result = $conn->query($sql);

// Check if records exist
if ($result->num_rows > 0) {
    // Set headers for download
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=record10_export.csv');

    // Open output stream
    $output = fopen('php://output', 'w');

    // Fetch and output field names (column headers)
    $fieldInfo = $result->fetch_fields();
    $headers = [];
    foreach ($fieldInfo as $val) {
        $headers[] = $val->name;
    }
    $headers[] = 'expiray'; // Add expiray column header
    fputcsv($output, $headers);

    // Fetch and output records with calculated expiray date
    while ($row = $result->fetch_assoc()) {
        // Assuming the installation date is in the format 'dd/mm/yyyy'
        $installationDate = DateTime::createFromFormat('d/m/Y', $row['INSTALLATION_DATE']);
        // Calculate the expiry date (example: add 365 days)
        $expirayDate = $installationDate->add(new DateInterval('P365D'))->format('d/m/Y');

        // Add the calculated expiray date to the row
        $row['expiray'] = $expirayDate;

        // Output the row with the calculated expiray date
        fputcsv($output, $row);
    }

    // Close output stream
    fclose($output);
} else {
    echo "No records found.";
}

// Close database connection
$conn->close();
?>
