<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filter Records</title>
    <style>
        /* Include the CSS from above here */
        body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    background-color: #f4f4f4;
    display: flex;
    flex-direction: column;
    min-height: 100vh;
}

h1 {
    text-align: center;
    color: #333;
    margin: 20px 0;
}

form {
    background-color: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    margin: 20px;
}

label {
    display: block;
    margin: 10px 0 5px;
}

input[type="text"], input[type="date"] {
    width: calc(100% - 22px);
    padding: 10px;
    margin-bottom: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

input[type="submit"] {
    background-color: #007bff;
    color: #fff;
    padding: 10px 20px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 16px;
    transition: background-color 0.3s;
}

input[type="submit"]:hover {
    background-color: #0056b3;
}

/* Container to hold table and fixed scrollbar */
.table-wrapper {
    position: relative;
    flex: 1;
    overflow: hidden; /* Hide any overflow from child elements */
}

.table-container {
    max-height: 500px; /* Adjust as needed */
    overflow-y: auto;
    margin-bottom: 30px; /* Space for fixed horizontal scrollbar */
}

.table-container::-webkit-scrollbar {
    height: 12px; /* Height of the horizontal scrollbar */
}

.table-container::-webkit-scrollbar-thumb {
    background-color: #007bff; /* Color of the scrollbar thumb */
    border-radius: 6px;
}

.table-container::-webkit-scrollbar-track {
    background-color: #f4f4f4; /* Color of the scrollbar track */
}

/* Table styling */
table {
    width: 100%;
    border-collapse: collapse;
    table-layout: fixed; /* Fixed layout for proper horizontal scrolling */
}

thead th {
    position: sticky;
    top: 0;
    background-color: #0056b3;
    color: #fff;
    z-index: 1; /* Ensures header stays above table content */
    border-bottom: 2px solid #004e92;
}

th, td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #ddd;
    white-space: nowrap; /* Prevent text wrapping */
}

.expired {
    background-color: #ffcccc; /* Light red for expired vehicles */
}

.zero-loan {
    background-color: #ccffcc; /* Light green for zero loan duration */
}

/* Fixed horizontal scrollbar */
.scrollbar-fixed {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background-color: #fff;
    border-top: 1px solid #ddd;
    z-index: 1000; /* Ensure it stays on top of other elements */
    overflow-x: auto;
}

.scrollbar-fixed table {
    width: 100%;
}


    </style>
</head>
<body>
    <h1>Filter Records</h1>

    <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get">
        <label for="sales_person">Sales Person:</label>
        <input type="text" id="sales_person" name="sales_person" value="<?php echo htmlspecialchars($sales_person); ?>">

        <label for="installation_date_start">Installation Date Start:</label>
        <input type="date" id="installation_date_start" name="installation_date_start" value="<?php echo htmlspecialchars($installation_date_start); ?>">

        <label for="installation_date_end">Installation Date End:</label>
        <input type="date" id="installation_date_end" name="installation_date_end" value="<?php echo htmlspecialchars($installation_date_end); ?>">

        <label for="client_name">Client Name:</label>
        <input type="text" id="client_name" name="client_name" value="<?php echo htmlspecialchars($client_name); ?>">

        <label for="vehicle_reg">Vehicle Registration:</label>
        <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>">

        <label for="technician">Technician:</label>
        <input type="text" id="technician" name="technician" value="<?php echo htmlspecialchars($technician); ?>">

        <input type="submit" value="Filter Records">
    </form>

    <?php if (!empty($results)): ?>
        <div class="table-wrapper">
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>INSTALLATION_DATE</th>
                            <th>CLIENT_NAME</th>
                            <th>SALES_PERSON</th>
                            <th>VEHICLE_REG</th>
                            <th>MODEL</th>
                            <th>TRACKER_NUMBER</th>
                            <th>CONTACT</th>
                            <th>Finacia</th>
                            <th>USERNAME</th>
                            <th>PASSWORD</th>
                            <th>LOAN_DURATION</th>
                            <th>C_NO</th>
                            <th>Expiry</th>
                            <th>TECHNICIAN</th>
                            <th>T_K</th>
                            <th>Tracksolid</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $serialNumber = 1;
                        foreach ($results as $row):
                            $currentDate = date('Y-m-d');
                            $expiryDate = $row['expiray'];
                            $isExpired = (strtotime($currentDate) > strtotime($expiryDate));
                            $loanDuration = isset($row['LOAN_DURATION']) ? $row['LOAN_DURATION'] : '';
                            $isZeroLoan = ($loanDuration === '0');

                            $rowClass = '';
                            if ($isExpired) {
                                $rowClass = 'expired';
                            }
                            if ($isZeroLoan || empty($loanDuration)) {
                                $rowClass .= ' zero-loan';
                            }
                        ?>
                            <tr class="<?php echo $rowClass; ?>">
                                <td><?php echo $serialNumber++; ?></td>
                                <td>
                                    <?php echo htmlspecialchars($row['INSTALLATION_DATE']); ?>
                                    <?php if ($isExpired): ?>
                                        <span style="color: red;">&#x26A0;</span> <!-- Warning symbol for expired vehicles -->
                                    <?php endif; ?>
                                    <?php if ($isZeroLoan || empty($loanDuration)): ?>
                                        <span style="color: blue;">?</span> <!-- ? for zero loan duration -->
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['CLIENT_NAME']); ?></td>
                                <td><?php echo htmlspecialchars($row['SALES_PERSON']); ?></td>
                                <td><?php echo htmlspecialchars($row['VEHICLE_REG']); ?></td>
                                <td><?php echo htmlspecialchars($row['MODEL']); ?></td>
                                <td><?php echo htmlspecialchars($row['TRACKER_NUMBER']); ?></td>
                                <td><?php echo htmlspecialchars($row['CONTACT']); ?></td>
                                <td><?php echo htmlspecialchars($row['Finacia']); ?></td>
                                <td><?php echo htmlspecialchars($row['USERNAME']); ?></td>
                                <td><?php echo htmlspecialchars($row['PASSWORD']); ?></td>
                                <td><?php echo htmlspecialchars($row['LOAN_DURATION']); ?></td>
                                <td><?php echo htmlspecialchars($row['C_NO']); ?></td>
                                <td><?php echo htmlspecialchars($row['expiray']); ?></td>
                                <td><?php echo htmlspecialchars($row['TECHNICIAN']); ?></td>
                                <td><?php echo htmlspecialchars($row['T_K']); ?></td>
                                <td><?php echo htmlspecialchars($row['Tracksolid']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Fixed horizontal scrollbar -->
            <div class="scrollbar-fixed">
                <table>
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>INSTALLATION_DATE</th>
                            <th>CLIENT_NAME</th>
                            <th>SALES_PERSON</th>
                            <th>VEHICLE_REG</th>
                            <th>MODEL</th>
                            <th>TRACKER_NUMBER</th>
                            <th>CONTACT</th>
                            <th>Finacia</th>
                            <th>USERNAME</th>
                            <th>PASSWORD</th>
                            <th>LOAN_DURATION</th>
                            <th>C_NO</th>
                            <th>Expiry</th>
                            <th>TECHNICIAN</th>
                            <th>T_K</th>
                            <th>Tracksolid</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    <?php else: ?>
        <p>No records found.</p>
    <?php endif; ?>
</body>
</html>
