<?php
session_start();
include 'conn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $identifier = $_POST['identifier']; // This can be either phone number or full name
    $password = $_POST['password'];

    // Prepare query to search by either phone number or full name
    $query = "SELECT * FROM users WHERE (phone_number = ? OR full_name = ?) AND password = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sss", $identifier, $identifier, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        $_SESSION['username'] = $user['full_name'];
        $_SESSION['access_level'] = $user['access_level'];  // Store the user's access level in the session
        header("Location: dashboard.php");
        exit();
    } else {
        $error_message = "Invalid phone number, full name, or password";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            background: url('background-image.jpg') no-repeat center center fixed;
            background-size: cover;
        }
        .login-container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 20px 40px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
        }
        .login-container h2 {
            margin-bottom: 20px;
        }
        .login-container label {
            display: block;
            margin-bottom: 8px;
            text-align: left;
        }
        .login-container input {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .login-container button {
            width: 100%;
            padding: 10px;
            background-color: blueviolet;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        .login-container button:hover {
            background-color: darkviolet;
        }
        .login-container .error-message {
            color: red;
            margin-bottom: 20px;
        }
        .login-container .icon {
            font-size: 3rem;
            color: blueviolet;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <i class="fas fa-user-circle icon"></i>
        <h2>Login</h2>
        <?php
        if (isset($error_message)) {
            echo '<div class="error-message">' . $error_message . '</div>';
        }
        ?>
        <form method="post" action="">
            <label for="identifier">Phone Number or Full Name:</label>
            <input type="text" name="identifier" id="identifier" required>
            <label for="password">Password:</label>
            <input type="password" name="password" id="password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
