<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert New Fuel Data</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color:lightblue;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            width: 90%;
            max-width: 1200px;
            padding: 20px;
            background-color:lavender;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.6);
            display: grid;
            gap: 10px;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
        }
        form label {
            display: block;
            margin-bottom: 5px;
        }
        input[type="text"], input[type="date"], textarea, select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            box-sizing: border-box;
        }
        input[type="submit"] {
            padding: 10px 20px;
            border: none;
            background-color: #007BFF;
            color: white;
            cursor: pointer;
            grid-column: span 2;
            justify-self: center;
        }
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
        .success {
            color: green;
            font-weight: bold;
            text-align: center;
            grid-column: span 2;
        }
        .error {
            color: red;
            font-weight: bold;
            text-align: center;
            grid-column: span 2;
        }
        @media (max-width: 768px) {
            form {
                grid-template-columns: 1fr;
            }
            input[type="submit"] {
                grid-column: span 1;
            }
            .success, .error {
                grid-column: span 1;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Insert New Fuel Data</h2>
        <?php
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            include 'conn.php';

            $installation_date = $conn->real_escape_string($_POST['installation_date']);
            $client_name = $conn->real_escape_string($_POST['client_name']);
            $contact = $conn->real_escape_string($_POST['contact']);
            $reg_no = $conn->real_escape_string($_POST['reg_no']);
            $make_model = $conn->real_escape_string($_POST['make_model']);
            $device_type = $conn->real_escape_string($_POST['device_type']);
            $tracker_no = $conn->real_escape_string($_POST['tracker_no']);
            $technician = $conn->real_escape_string($_POST['technician']);
            $sales_person = $conn->real_escape_string($_POST['sales_person']);
            $login_password_comments = $conn->real_escape_string($_POST['login_password_comments']);
            $location = $conn->real_escape_string($_POST['location']);
            $expiration_date = $conn->real_escape_string($_POST['expiration_date']);

            $sql = "INSERT INTO newfuel (
                        `INSTALLATION DATE`, `Client Name`, CONTACT, `REG NO`, 
                        `MAKE/MODEL`, `DEVICE TYPE`, `TRACKER NO`, TECHNICIAN, 
                        `SALES PERSON`, `LOGIN PASSWORD/COMMENTS`, LOCATION, 
                        `Expiration date`
                    ) VALUES (
                        '$installation_date', '$client_name', '$contact', '$reg_no', 
                        '$make_model', '$device_type', '$tracker_no', '$technician', 
                        '$sales_person', '$login_password_comments', '$location', 
                        '$expiration_date'
                    )";

            if ($conn->query($sql) === TRUE) {
                echo "<p class='success'>New record created successfully</p>";
            } else {
                echo "<p class='error'>Error: " . $sql . "<br>" . $conn->error . "</p>";
            }

            $conn->close();
        }
        ?>

        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
            <div>
                <label for="installation_date">Installation Date:</label>
                <input type="date" id="installation_date" name="installation_date" required>
            </div>
            
            <div>
                <label for="client_name">Client Name:</label>
                <input type="text" id="client_name" name="client_name" required>
            </div>
            
            <div>
                <label for="contact">Contact:</label>
                <input type="text" id="contact" name="contact">
            </div>
            
            <div>
                <label for="reg_no">Registration Number:</label>
                <input type="text" id="reg_no" name="reg_no" required>
            </div>
            
            <div>
                <label for="make_model">Make/Model:</label>
                <input type="text" id="make_model" name="make_model">
            </div>
            
            <div>
                <label for="device_type">Device Type:</label>
                <input type="text" id="device_type" name="device_type">
            </div>
            
            <div>
                <label for="tracker_no">Tracker Number:</label>
                <input type="text" id="tracker_no" name="tracker_no">
            </div>

            <div>
                <label for="technician">Technician:</label>
                <select id="technician" name="technician" required>
                    <option value="">Select Technician</option>
                    <?php
                    include 'conn.php';
                    $sql = "SELECT * FROM technicians";
                    $result = $conn->query($sql);
                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<option value='" . $row['name'] . "'>" . $row['name'] . "</option>";
                        }
                    }
                    $conn->close();
                    ?>
                </select>
            </div>
            
            <div>
                <label for="sales_person">Sales Person:</label>
                <select id="sales_person" name="sales_person" required>
                    <option value="">Select Sales Person</option>
                    <?php
                    include 'conn.php';
                    $sql = "SELECT * FROM salespersons";
                    $result = $conn->query($sql);
                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<option value='" . $row['name'] . "'>" . $row['name'] . "</option>";
                        }
                    }
                    $conn->close();
                    ?>
                </select>
            </div>

            <div>
                <label for="login_password_comments">Login Password/Comments:</label>
                <textarea id="login_password_comments" name="login_password_comments"></textarea>
            </div>
            
            <div>
                <label for="location">Location:</label>
                <input type="text" id="location" name="location">
            </div>
            
            <div>
                <label for="expiration_date">Expiration Date:</label>
                <input type="date" id="expiration_date" name="expiration_date">
            </div>
            
            <input type="submit" value="Insert">
          
        </form>
        <a href="dashboard.php" style="display: inline-block; padding: 10px 20px; font-size: 16px; text-decoration: none; color: #fff; background-color: #2670b9; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease">Return To Home</a>
    </div>
</body>
</html>
