<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

// Handle form submission to insert data into the users table
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $phone_number = $_POST['phone_number'] ?? '';
    $full_name = $_POST['full_name'] ?? '';
    $access_level = $_POST['access_level'] ?? '';

    // Validate input fields
    if (empty($phone_number) || empty($full_name) || empty($access_level)) {
        $message = "All fields are required.";
        $message_type = "error";
    } else {
        // Insert into the database
        $query = "INSERT INTO users (phone_number, full_name, access_level) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('sss', $phone_number, $full_name, $access_level);

        if ($stmt->execute()) {
            $message = "New user added successfully!";
            $message_type = "success";
        } else {
            $message = "Error: " . $stmt->error;
            $message_type = "error";
        }
    }
}

// Fetch all users from the database
$query = "SELECT * FROM users";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Users Table</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 90%;
            margin: auto;
            overflow: hidden;
        }

        .form-container, .table-container {
            background: #fff;
            padding: 20px;
            margin: 20px 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border-radius: 8px;
        }

        h2 {
            color: #333;
        }

        label {
            display: block;
            margin-top: 10px;
        }

        input[type="text"], select, button {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }

        button {
            background-color: #28a745;
            color: #fff;
            border: none;
            cursor: pointer;
            margin-top: 10px;
        }

        button:hover {
            background-color: #218838;
        }

        .message {
            margin-top: 20px;
            padding: 10px;
            border-radius: 4px;
        }

        .message.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 12px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .fixed-bottom-scrollbar {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: #fff;
            overflow-x: auto;
            border-top: 1px solid #ccc;
            box-shadow: 0 -2px 4px rgba(0,0,0,0.1);
        }

        .fixed-bottom-scrollbar table {
            width: 100%;
            margin: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-container">
            <h2>Add New User</h2>
            <?php if (isset($message)): ?>
                <div class="message <?php echo $message_type; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            <form action="insert_user.php" method="POST">
                <label for="phone_number">Phone Number:</label>
                <input type="text" id="phone_number" name="phone_number" required>
                <label for="full_name">Full Name:</label>
                <input type="text" id="full_name" name="full_name" required>
                <label for="access_level">Access Level:</label>
                <select id="access_level" name="access_level" required>
                    <option value="MD">MD</option>
                    <option value="ADMIN">ADMIN</option>
                    <option value="SUPPORT">SUPPORT</option>
                </select>
                <button type="submit">Add User</button>
            </form>
        </div>

        <div class="table-container">
            <h2>Users Table</h2>
            <table>
                <thead>
                    <tr>
                        <th>Phone Number</th>
                        <th>Full Name</th>
                        <th>Access Level</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result && $result->num_rows > 0): ?>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['phone_number']); ?></td>
                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['access_level']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3">No users found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="fixed-bottom-scrollbar">
        <table>
            <tr>
                <td>Scroll bar is fixed at the bottom of the page.</td>
            </tr>
        </table>
    </div>

    <script>
        document.querySelector('.fixed-bottom-scrollbar').addEventListener('scroll', function(e) {
            document.querySelector('.table-container').scrollLeft = e.target.scrollLeft;
        });
    </script>
</body>
</html>

<?php
$conn->close();
?>
