<?php
// Include the connection page
include 'conn.php';

$success_message = $error_message = '';
$phone_number = $full_name = '';

// Handle adding, editing, and deleting sales persons
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['add_sales_person'])) {
        // Add new sales person
        $phone_number = $_POST['phone_number'];
        $full_name = $_POST['full_name'];
        $password = '0000'; // Default password

        // Check if phone number already exists
        $check_stmt = $conn->prepare("SELECT 1 FROM sales_person WHERE phone_number = ?");
        $check_stmt->bind_param("s", $phone_number);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            $error_message = "Error: Sales Person with Phone Number '$phone_number' already exists.";
        } else {
            // Proceed with insertion
            $insert_stmt = $conn->prepare("INSERT INTO sales_person (phone_number, full_name, password) VALUES (?, ?, ?)");
            $insert_stmt->bind_param("sss", $phone_number, $full_name, $password);

            if ($insert_stmt->execute()) {
                $success_message = "New sales person added successfully";
            } else {
                $error_message = "Error: Unable to add sales person. Please try again later.";
            }

            $insert_stmt->close();
        }

        $check_stmt->close();
    } elseif (isset($_POST['edit_sales_person'])) {
        // Edit existing sales person
        $phone_number = $_POST['phone_number'];
        $new_full_name = $_POST['full_name'];

        // Update sales_person table with new full name
        $update_stmt = $conn->prepare("UPDATE sales_person SET full_name = ? WHERE phone_number = ?");
        $update_stmt->bind_param("ss", $new_full_name, $phone_number);

        if ($update_stmt->execute()) {
            $success_message = "Sales person record updated successfully";
        } else {
            $error_message = "Error updating sales person record: " . $conn->error;
        }

        $update_stmt->close();
    }
}

// Handle deleting sales person
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['delete'])) {
    $phone_number = $_GET['phone_number'];

    // Delete sales person from sales_person table
    $delete_stmt = $conn->prepare("DELETE FROM sales_person WHERE phone_number = ?");
    $delete_stmt->bind_param("s", $phone_number);

    if ($delete_stmt->execute()) {
        $success_message = "Sales person record deleted successfully";
    } else {
        $error_message = "Error deleting sales person record: " . $conn->error;
    }

    $delete_stmt->close();
}

// Fetch all sales persons for display
$select_stmt = $conn->prepare("SELECT phone_number, full_name FROM sales_person");
$select_stmt->execute();
$select_stmt->bind_result($phone_number, $full_name);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Sales Persons</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center">Manage Sales Persons</h2>
        <?php
        if (!empty($success_message)) {
            echo '<div class="alert alert-success">' . htmlspecialchars($success_message) . '</div>';
        }
        if (!empty($error_message)) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($error_message) . '</div>';
        }
        ?>
        <!-- Add and Edit Sales Person Form -->
        <div class="card mb-3">
            <div class="card-header">
                <?php if (isset($_GET['phone_number'])): ?>
                    Edit Sales Person
                <?php else: ?>
                    Add New Sales Person
                <?php endif; ?>
            </div>
            <div class="card-body">
                <form action="manage_sales_persons.php" method="post">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="phone_number">Phone Number</label>
                            <input type="text" class="form-control" id="phone_number" name="phone_number" value="<?php echo isset($_GET['phone_number']) ? htmlspecialchars($_GET['phone_number']) : ''; ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="full_name">Full Name</label>
                            <input type="text" class="form-control" id="full_name" name="full_name" value="<?php echo isset($_GET['phone_number']) ? htmlspecialchars($full_name) : ''; ?>" required>
                        </div>
                    </div>
                    <?php if (isset($_GET['phone_number'])): ?>
                        <button type="submit" class="btn btn-primary" name="edit_sales_person">Update Sales Person</button>
                    <?php else: ?>
                        <button type="submit" class="btn btn-primary" name="add_sales_person">Add Sales Person</button>
                    <?php endif; ?>
                     <a href="dashboard.php" style="display: inline-block; padding: 8px 15px; font-size: 14px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
                </form>
            </div>
        </div>

        <!-- List of Sales Persons -->
        <div class="card">
            <div class="card-header">
                List of Sales Persons
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Phone Number</th>
                            <th>Full Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($select_stmt->fetch()) { ?>
                            <tr>
                                <td><?php echo htmlspecialchars($phone_number); ?></td>
                                <td><?php echo htmlspecialchars($full_name); ?></td>
                                <td>
                                    <a href="manage_sales_persons.php?phone_number=<?php echo urlencode($phone_number); ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="manage_sales_persons.php?delete=true&phone_number=<?php echo urlencode($phone_number); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this sales person?')">Delete</a>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
