<?php
// Start session to retrieve user access level
session_start();

// Check if user is logged in and determine access level
$user_access_level = isset($_SESSION['access_level']) ? $_SESSION['access_level'] : '';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Vehicle</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            margin: 20px auto;
            padding: 5px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 20px;
        }
        input[type="text"] {
            width: 70%;
            padding: 10px;
            margin-right: 10px;
            border: 1px solid #ddd;
        }
        input[type="submit"], .clear-btn, .home-btn {
            padding: 10px 20px;
            border: none;
            color: white;
            cursor: pointer;
        }
        input[type="submit"] {
            background-color: #007BFF;
        }
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
        .clear-btn {
            background-color: #6c757d;
        }
        .clear-btn:hover {
            background-color: #5a6268;
        }
        .home-btn {
            background-color: #28a745;
        }
        .home-btn:hover {
            background-color: #218838;
        }
        .result {
            margin-top: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            border: 1px solid #ddd;
            text-align: left;
            font-size: 14px;
        }
        th {
            background-color: #007BFF;
            color: white;
        }
        .error {
            color: red;
            font-weight: bold;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Search Vehicle</h2>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
            <input type="text" name="vehicle_reg" placeholder="Enter Vehicle Registration Number" required>
            <input type="submit" value="Search">
            <button type="button" class="clear-btn" onclick="window.location.reload();">Clear</button>
            <button type="button" class="home-btn" onclick="window.location.href='dashboard.php';">Home</button>
        </form>

        <div class="result">
            <?php
            // Check if form is submitted
            if ($_SERVER["REQUEST_METHOD"] == "POST") {
                // Include database connection
                include 'conn.php';

                // Sanitize input
                $vehicle_reg = $conn->real_escape_string($_POST['vehicle_reg']);
                
                // Query to retrieve records using LIKE operator
                $sql = "SELECT * FROM installation_record___fuel_installation_record__2_ WHERE `REG NO` LIKE '%$vehicle_reg%'";
                $result = $conn->query($sql);
                
                if ($result->num_rows > 0) {
                    echo "<table>
                            <tr>
                                <th>CUSTODIAN</th>
                                <th>F</th>
                                <th>INSTALLATION DATE</th>
                                <th>Client Name</th>";

                    // Check user access level to decide whether to display CONTACT column
                    if ($user_access_level != 'Support') {
                        echo "<th>CONTACT</th>";
                    }

                    echo "<th>REG NO</th>
                          <th>MAKE/MODEL</th>
                          <th>DEVICE TYPE</th>
                          <th>TRACKER NO</th>
                          <th>TECHNICIAN</th>
                          <th>SALES PERSON</th>
                          <th>LOGIN PASSWORD/COMMENTS</th>
                          <th>LOCATION</th>
                        </tr>";
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>
                                <td>" . $row["CUSTODIAN"] . "</td>
                                <td>" . $row["F"] . "</td>
                                <td>" . $row["INSTALLATION DATE"] . "</td>
                                <td>" . $row["Client Name"] . "</td>";

                        // Check user access level to decide whether to display CONTACT column
                        if ($user_access_level != 'Support') {
                            echo "<td>" . $row["CONTACT"] . "</td>";
                        }

                        echo "<td>" . $row["REG NO"] . "</td>
                              <td>" . $row["MAKE/MODEL"] . "</td>
                              <td>" . $row["DEVICE TYPE"] . "</td>
                              <td>" . $row["TRACKER NO:"] . "</td>
                              <td>" . $row["TECHNICIAN"] . "</td>
                              <td>" . $row["SALES PERSON"] . "</td>
                              <td>" . $row["LOGIN PASSWORD/COMMENTS"] . "</td>
                              <td>" . $row["LOCATION"] . "</td>
                            </tr>";
                    }
                    echo "</table>";
                } else {
                    echo "<p class='error'>No records found for the given vehicle registration number.</p>";
                }
                
                // Close connection
                $conn->close();
            }
            ?>
        </div>
    </div>
</body>
</html>
