<?php
session_start();
include 'conn.php';

$access_level = $_SESSION['access_level'];
$search = '';
$search_field = '';
$filter = '';

// Check if a filter request is made
if (isset($_GET['filter'])) {
    $filter = $_GET['filter'];
    if ($filter === 'expired') {
        $query = "SELECT * FROM installrecord WHERE expiration_date < '" . date('Y-m-d') . "' AND expiration_date != '0000-00-00' ORDER BY date_of_installation DESC";
    } elseif ($filter === 'active') {
        $query = "SELECT * FROM installrecord WHERE expiration_date >= '" . date('Y-m-d') . "' ORDER BY date_of_installation DESC";
    } elseif ($filter === 'no_expiration') {
        $query = "SELECT * FROM installrecord WHERE expiration_date = '0000-00-00' ORDER BY date_of_installation DESC";
    }
} elseif (isset($_POST['search']) && isset($_POST['search_field'])) {
    $search = $_POST['search'];
    $search_field = $_POST['search_field'];
    $query = "SELECT * FROM installrecord WHERE " . mysqli_real_escape_string($conn, $search_field) . " LIKE '%" . mysqli_real_escape_string($conn, $search) . "%' ORDER BY date_of_installation DESC";
} else {
    $query = "SELECT * FROM installrecord WHERE expiration_date >= '" . date('Y-m-d') . "' ORDER BY date_of_installation DESC";
}

$result = mysqli_query($conn, $query);

$rows = [];

while ($row = mysqli_fetch_assoc($result)) {
    $expiration_date = isset($row['expiration_date']) ? $row['expiration_date'] : '';
    $status = '';

    if ($expiration_date === '0000-00-00') {
        $status = 'NO EXPIRATION DATE';
    } elseif (!empty($expiration_date)) {
        $today = date('Y-m-d');
        if ($expiration_date >= $today) {
            $status = 'Active';

            // Calculate days remaining
            $exp_date = new DateTime($expiration_date);
            $today_date = new DateTime($today);
            $diff = $today_date->diff($exp_date)->days;

            // Add days remaining to row data
            $row['days_remaining'] = $diff;
        } else {
            $status = 'Expired';
        }
    }

    if ($status === 'Active') {
        $row['status'] = $status;
        $rows[] = $row;
    }
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Active Vehicles</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            margin: 0;
            padding: 0;
        }

        .container {
            margin: 20px auto;
            padding: 10px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            font-size: 14px;
        }

        h2 {
            color: #2670b9;
            text-align: center;
            margin-bottom: 20px;
        }

        .search-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .search-container input[type="text"],
        .search-container select {
            width: calc(30% - 20px);
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin: 0 10px;
            box-sizing: border-box;
        }

        .search-container input[type="submit"],
        .search-container input[type="button"] {
            padding: 10px 20px;
            font-size: 16px;
            border: none;
            border-radius: 5px;
            background-color: #2670b9;
            color: #fff;
            cursor: pointer;
            margin-left: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ccc;
        }

        th {
            background-color: #f0f8ff;
            font-size: 14px;
            font-weight: bold;
            text-align: center;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        td.active {
            background-color: #e6f7ff; /* Background color for active vehicles */
        }

        a {
            color: #2670b9;
            text-decoration: none;
            display: block;
            margin-top: 10px;
        }

        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Active Vehicles</h2>
        <div class="search-container">
            <form method="POST" action="">
                <select name="search_field">
                    <option value="" disabled <?php if (!$search_field) echo 'selected'; ?>>Select Search Type</option>
                    <option value="vehicle_reg" <?php if ($search_field == 'vehicle_reg') echo 'selected'; ?>>Vehicle Registration</option>
                    <option value="client_name" <?php if ($search_field == 'client_name') echo 'selected'; ?>>Client Name</option>
                    <option value="tracker_number" <?php if ($search_field == 'tracker_number') echo 'selected'; ?>>Tracker Number</option>
                </select>
                <input type="text" name="search" id="search" placeholder="Enter <?php echo str_replace('_', ' ', htmlspecialchars($search_field)); ?>" value="<?php echo htmlspecialchars($search); ?>">
                <input type="submit" value="Search">
                <input type="button" value="Reset" onclick="window.location.href='active_vehicles.php'">
                <input type="button" value="Home" onclick="window.location.href='dashboard.php'">
                <span style="margin-left: 10px;">Today's Date: <?php echo date('Y-m-d'); ?></span>
            </form>
        </div>

        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Vehicle Registration</th>
                    <th>Days Remaining to Expiry</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rows as $key => $row) : ?>
                    <tr class="active">
                        <td><?php echo $key + 1; ?></td>
                        <td><?php echo htmlspecialchars($row['vehicle_reg']); ?></td>
                        <td><?php echo isset($row['days_remaining']) ? $row['days_remaining'] : ''; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
   <input type="button" value="Print Table" onclick="printTable()">

    </div>

    <script>
    
    function printTable() {
        var table = document.querySelector('table'); // Get the table
        if (table) {
            var newWin = window.open('', 'Print-Window'); // Open a new window for printing
            newWin.document.open();
            newWin.document.write('<html><head><title>Print Table</title>'); // Write HTML content for the new window
            newWin.document.write('<style>');
            newWin.document.write('body { font-family: Arial, sans-serif; }');
            newWin.document.write('table { width: 100%; border-collapse: collapse; margin-top: 10px; }');
            newWin.document.write('th, td { padding: 8px; text-align: left; border: 1px solid #ccc; }');
            newWin.document.write('th { background-color: #f0f8ff; font-size: 14px; font-weight: bold; text-align: center; }');
            newWin.document.write('tr:nth-child(even) { background-color: #f2f2f2; }');
            newWin.document.write('td.active { background-color: #e6f7ff; }');
            newWin.document.write('</style></head><body>'); // Write the style and body start tag
            newWin.document.write('<h2>Active Vehicles</h2>'); // Heading for the print page
            newWin.document.write(table.outerHTML); // Write the table content
            newWin.document.write('</body></html>'); // Close HTML tags
            newWin.document.close();
            newWin.print(); // Trigger the print dialog
            newWin.close(); // Close the new window after printing
        }
    }


    </script>
</body>
</html>
