<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Vehicle Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            max-width: 600px;
            margin: 50px auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .container h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            box-sizing: border-box;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #dc3545;
            color: white;
            border: none;
            cursor: pointer;
            text-align: center;
            font-size: 16px;
            margin-top: 10px;
        }
        .btn:hover {
            background-color: #c82333;
        }
        .btn-confirm {
            background-color: #28a745;
        }
        .btn-confirm:hover {
            background-color: #218838;
        }
        .record {
            margin-top: 20px;
            padding: 10px;
            background: #f9f9f9;
            border: 1px solid #ddd;
        }
        .record p {
            margin: 5px 0;
        }
        @media (max-width: 600px) {
            .container {
                width: 100%;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Delete Vehicle Record</h2>
        <?php
        include "conn.php";

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if (isset($_POST['confirm_delete'])) {
                // Prepare and bind
                $stmt = $conn->prepare("DELETE FROM record10 WHERE VEHICLE_REG = ?");
                $stmt->bind_param("s", $vehicle_reg);

                // Set parameters and execute
                $vehicle_reg = $_POST['vehicle_reg'];
                if ($stmt->execute()) {
                    echo "<p style='color:green;'>Record deleted successfully</p>";
                } else {
                    echo "<p style='color:red;'>Error: " . $stmt->error . "</p>";
                }

                $stmt->close();
                $conn->close();
            } else {
                // Prepare and bind
                $stmt = $conn->prepare("SELECT * FROM record10 WHERE VEHICLE_REG = ?");
                $stmt->bind_param("s", $vehicle_reg);

                // Set parameters and execute
                $vehicle_reg = $_POST['vehicle_reg'];
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    $record = $result->fetch_assoc();
                    echo "<div class='record'>";
                    echo "<p><strong>INSTALLATION_DATE:</strong> " . htmlspecialchars($record['INSTALLATION_DATE']) . "</p>";
                    echo "<p><strong>CLIENT_NAME:</strong> " . htmlspecialchars($record['CLIENT_NAME']) . "</p>";
                    echo "<p><strong>SALES_PERSON:</strong> " . htmlspecialchars($record['SALES_PERSON']) . "</p>";
                    echo "<p><strong>VEHICLE_REG:</strong> " . htmlspecialchars($record['VEHICLE_REG']) . "</p>";
                    echo "<p><strong>MODEL:</strong> " . htmlspecialchars($record['MODEL']) . "</p>";
                    echo "<p><strong>TRACKER_NUMBER:</strong> " . htmlspecialchars($record['TRACKER_NUMBER']) . "</p>";
                    echo "<p><strong>CONTACT:</strong> " . htmlspecialchars($record['CONTACT']) . "</p>";
                    echo "<p><strong>Bank:</strong> " . htmlspecialchars($record['Bank']) . "</p>";
                    echo "<p><strong>TECHNICIAN:</strong> " . htmlspecialchars($record['TECHNICIAN']) . "</p>";
                    echo "<p><strong>T_K:</strong> " . htmlspecialchars($record['T_K']) . "</p>";
                    echo "<p><strong>Tracksolid:</strong> " . htmlspecialchars($record['Tracksolid']) . "</p>";
                    echo "<p><strong>USERNAME:</strong> " . htmlspecialchars($record['USERNAME']) . "</p>";
                    echo "<p><strong>PASSWORD:</strong> " . htmlspecialchars($record['PASSWORD']) . "</p>";
                    echo "<p><strong>LOAN_DURATION:</strong> " . htmlspecialchars($record['LOAN_DURATION']) . "</p>";
                    echo "<p><strong>C_NO:</strong> " . htmlspecialchars($record['C_NO']) . "</p>";
                    echo "<p><strong>EXPIRY:</strong> " . htmlspecialchars($record['expiray']) . "</p>";
                    echo "</div>";

                    echo "<form action='' method='POST'>";
                    echo "<input type='hidden' name='vehicle_reg' value='" . htmlspecialchars($vehicle_reg) . "'>";
                    echo "<button type='submit' name='confirm_delete' class='btn btn-confirm'><i class='fas fa-check'></i> Confirm Delete</button>";
                    echo "</form>";
                } else {
                    echo "<p style='color:red;'>No record found for Vehicle Registration: " . htmlspecialchars($vehicle_reg) . "</p>";
                }

                $stmt->close();
            }
        }
        ?>
        <form action="" method="POST">
            <div class="form-group">
                <label for="vehicle_reg"><i class="fas fa-car"></i> Vehicle Registration</label>
                <input type="text" id="vehicle_reg" name="vehicle_reg" required>
            </div>
            <button type="submit" class="btn"><i class="fas fa-trash-alt"></i> Delete</button>
            <a href="dashboard.php" style="display: inline-block; padding: 10px 20px; margin-top: 10px; font-size: 16px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
        </form>
    </div>
</body>
</html>
