<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Vehicle Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 50%;
            margin: 50px auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input, .form-group textarea {
            width: 100%;
            padding: 10px;
            box-sizing: border-box;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #007bff;
            color: #fff;
            text-align: center;
            border: none;
            cursor: pointer;
        }
        .btn i {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Edit Vehicle Record</h2>
        <form method="post" action="">
            <div class="form-group">
                <label for="vehicle_reg"><i class="fas fa-car"></i> Vehicle Registration Number</label>
                <input type="text" id="vehicle_reg" name="vehicle_reg" required>
            </div>
            <button type="submit" name="submit" class="btn"><i class="fas fa-search"></i> Search</button>
            <a href="dashboard.php" style="display: inline-block; padding: 10px 20px; margin-top: 10px; font-size: 16px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
        </form>

        <?php
        // Check if form submitted
        if (isset($_POST['submit'])) {
            // Retrieve vehicle registration number from form
            $vehicle_reg = $_POST['vehicle_reg'];

            // Database connection
            include "conn.php";

            // SQL query to fetch record based on vehicle registration number
            $sql = "SELECT * FROM record10 WHERE VEHICLE_REG = '$vehicle_reg'";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                // Output data of each row
                $row = $result->fetch_assoc();
                ?>
                <hr>
                <h3>Editing Record for Vehicle Registration Number: <?php echo htmlspecialchars($row['VEHICLE_REG']); ?></h3>
                <form method="post" action="">
                    <input type="hidden" name="vehicle_reg" value="<?php echo htmlspecialchars($row['VEHICLE_REG']); ?>">
                    <div class="form-group">
                        <label for="installation_date"><i class="fas fa-calendar-alt"></i> Installation Date (mm/dd/yyyy)</label>
                        <input type="text" id="installation_date" name="installation_date" value="<?php echo htmlspecialchars($row['INSTALLATION_DATE']); ?>">
                    </div>
                    
                    <div class="form-group">
                        <label for="client_name"><i class="fas fa-user"></i> Client Name</label>
                        <input type="text" id="client_name" name="client_name" value="<?php echo htmlspecialchars($row['CLIENT_NAME']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="sales_person"><i class="fas fa-user-tie"></i> Sales Person</label>
                        <input type="text" id="sales_person" name="sales_person" value="<?php echo htmlspecialchars($row['SALES_PERSON']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="model"><i class="fas fa-car-side"></i> Model</label>
                        <input type="text" id="model" name="model" value="<?php echo htmlspecialchars($row['MODEL']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="tracker_number"><i class="fas fa-satellite-dish"></i> Tracker Number</label>
                        <input type="text" id="tracker_number" name="tracker_number" value="<?php echo htmlspecialchars($row['TRACKER_NUMBER']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="contact"><i class="fas fa-phone-alt"></i> Contact</label>
                        <input type="text" id="contact" name="contact" value="<?php echo htmlspecialchars($row['CONTACT']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="bank"><i class="fas fa-file-invoice-dollar"></i> Bank</label>
                        <input type="text" id="bank" name="bank" value="<?php echo htmlspecialchars($row['Bank']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="technician"><i class="fas fa-user-cog"></i> Technician</label>
                        <input type="text" id="technician" name="technician" value="<?php echo htmlspecialchars($row['TECHNICIAN']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="t_k"><i class="fas fa-tools"></i> T.K</label>
                        <input type="text" id="t_k" name="t_k" value="<?php echo htmlspecialchars($row['T_K']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="tracksolid"><i class="fas fa-globe"></i> Tracksolid</label>
                        <input type="text" id="tracksolid" name="tracksolid" value="<?php echo htmlspecialchars($row['Tracksolid']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="username"><i class="fas fa-user"></i> Username</label>
                        <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($row['USERNAME']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="password"><i class="fas fa-key"></i> Password</label>
                        <input type="password" id="password" name="password" value="<?php echo htmlspecialchars($row['PASSWORD']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="loan_duration"><i class="fas fa-clock"></i> Loan Duration</label>
                        <input type="text" id="loan_duration" name="loan_duration" value="<?php echo htmlspecialchars($row['LOAN_DURATION']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="c_no"><i class="fas fa-hashtag"></i> C/NO</label>
                        <input type="text" id="c_no" name="c_no" value="<?php echo htmlspecialchars($row['C_NO']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="expiray"><i class="fas fa-exclamation-circle"></i> Expiry Date (mm/dd/yyyy)</label>
                        <input type="text" id="expiray" name="expiray" value="<?php echo htmlspecialchars($row['expiray']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="description"><i class="fas fa-info-circle"></i> Description</label>
                        <textarea id="description" name="description"><?php echo htmlspecialchars($row['description']); ?></textarea>
                    </div>

                    <button type="submit" name="update_record" class="btn"><i class="fas fa-save"></i> Save Changes</button>
                </form>
                <?php
            } else {
                echo "<p>No record found for Vehicle Registration Number: $vehicle_reg</p>";
            }

            // Close connection
            $conn->close();
        }

        // Process form submission for updating record and inserting into renewed_records
        if (isset($_POST['update_record'])) {
            // Retrieve form data
            $vehicle_reg = $_POST['vehicle_reg'];
            $installation_date = $_POST['installation_date'];
            $client_name = $_POST['client_name'];
            $sales_person = $_POST['sales_person'];
            $model = $_POST['model'];
            $tracker_number = $_POST['tracker_number'];
            $contact = $_POST['contact'];
            $bank = $_POST['bank']; // Added bank field
            $technician = $_POST['technician'];
            $t_k = $_POST['t_k'];
            $tracksolid = $_POST['tracksolid'];
            $username = $_POST['username'];
            $password = $_POST['password'];
            $loan_duration = $_POST['loan_duration'];
            $c_no = $_POST['c_no'];
            $expiray = $_POST['expiray'];
            $description = $_POST['description'];

            // Database connection
            include "conn.php";

            // SQL query to update record in record10 table
            $sql_update_record10 = "UPDATE record10 SET 
                                   INSTALLATION_DATE = '$installation_date', 
                                   CLIENT_NAME = '$client_name', 
                                   SALES_PERSON = '$sales_person', 
                                   MODEL = '$model', 
                                   TRACKER_NUMBER = '$tracker_number', 
                                   CONTACT = '$contact', 
                                   Bank = '$bank', 
                                   TECHNICIAN = '$technician', 
                                   T_K = '$t_k', 
                                   Tracksolid = '$tracksolid', 
                                   USERNAME = '$username', 
                                   PASSWORD = '$password', 
                                   LOAN_DURATION = '$loan_duration', 
                                   C_NO = '$c_no', 
                                   expiray = '$expiray' 
                                   WHERE VEHICLE_REG = '$vehicle_reg'";

            if ($conn->query($sql_update_record10) === TRUE) {
                // SQL query to insert into renewed_records table
                $sql_insert_renewed = "INSERT INTO renewed_records 
                                      (VEHICLE_REG, INSTALLATION_DATE, CLIENT_NAME, SALES_PERSON, MODEL, TRACKER_NUMBER, CONTACT, Bank, TECHNICIAN, T_K, Tracksolid, USERNAME, PASSWORD, LOAN_DURATION, C_NO, expiray, description)
                                      VALUES ('$vehicle_reg', '$installation_date', '$client_name', '$sales_person', '$model', '$tracker_number', '$contact', '$bank', '$technician', '$t_k', '$tracksolid', '$username', '$password', '$loan_duration', '$c_no', '$expiray', '$description')";

                if ($conn->query($sql_insert_renewed) === TRUE) {
                    echo "<p>Record updated and inserted into renewed_records successfully!</p>";
                } else {
                    echo "Error: " . $sql_insert_renewed . "<br>" . $conn->error;
                }
            } else {
                echo "Error updating record: " . $conn->error;
            }

            // Close connection
            $conn->close();
        }
        ?>
    </div>
</body>
</html>
