<?php
session_start(); // Start the session

// Check if user is logged in; if not, redirect to login page


// Include your database connection
include "conn.php";

// Initialize variables to hold form input
$installation_date = $client_name = $sales_person = $vehicle_reg = $model = $tracker_number = $contact = $bank = $technician = $t_k = $tracksolid = $username = $password = $loan_duration = $c_no = $expiray = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $installation_date = $_POST['installation_date'];
    $client_name = $_POST['client_name'];
    $sales_person = $_POST['sales_person'];
    $vehicle_reg = $_POST['vehicle_reg'];
    $model = $_POST['model'];
    $tracker_number = $_POST['tracker_number'];
    $contact = $_POST['contact'];
    $bank = $_POST['bank']; // Updated variable
    $technician = $_POST['technician'];
    $t_k = $_POST['t_k'];
    $tracksolid = $_POST['tracksolid'];
    $username = $_POST['username'];
    $password = $_POST['password'];
    $loan_duration = $_POST['loan_duration'];
    $c_no = $_POST['c_no'];
    $expiray = $_POST['expiray'];

    // Format dates to mm/dd/yyyy for MySQL storage
    $formatted_installation_date = date('m/d/Y', strtotime($installation_date));
    $formatted_expiray = date('m/d/Y', strtotime($expiray));

    $sql = "INSERT INTO record10 (INSTALLATION_DATE, CLIENT_NAME, SALES_PERSON, VEHICLE_REG, MODEL, TRACKER_NUMBER, CONTACT, Bank, TECHNICIAN, T_K, Tracksolid, USERNAME, PASSWORD, LOAN_DURATION, C_NO, expiray)
            VALUES ('$formatted_installation_date', '$client_name', '$sales_person', '$vehicle_reg', '$model', '$tracker_number', '$contact', '$bank', '$technician', '$t_k', '$tracksolid', '$username', '$password', '$loan_duration', '$c_no', '$formatted_expiray')";

    if ($conn->query($sql) === TRUE) {
        echo "<p class='alert success'>New record created successfully</p>";
        // Clear input fields after successful insertion
        $installation_date = $client_name = $sales_person = $vehicle_reg = $model = $tracker_number = $contact = $bank = $technician = $t_k = $tracksolid = $username = $password = $loan_duration = $c_no = $expiray = '';
    } else {
        echo "<p class='alert error'>Error: " . $sql . "<br>" . $conn->error . "</p>";
    }
}

// Fetch sales persons for dropdown
$sales_query = "SELECT phone_number, full_name FROM sales_person";
$sales_result = $conn->query($sales_query);

// Fetch technicians for dropdown
$tech_query = "SELECT phone_number, full_name FROM technician";
$tech_result = $conn->query($tech_query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Vehicle Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="styles.css"> <!-- Link to your CSS file -->
</head>
<style>
    body {
        font-family: Arial, sans-serif;
        background-color: #f0f2f5;
        margin: 0;
        padding: 0;
    }

    .container {
        width: 90%;
        max-width: 1200px;
        height: 90vh; /* Ensure the container fits within the viewport height */
        margin: 20px auto;
        background: #ffffff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        border: 1px solid #e0e0e0;
        display: flex;
        flex-direction: column;
        justify-content: flex-start; /* Align items to the start */
        overflow-y: auto; /* Enable vertical scrolling if needed */
    }

    .container h2 {
        text-align: center;
        color: #333;
        margin-bottom: 20px;
        font-size: 24px;
        border-bottom: 2px solid #007bff;
        padding-bottom: 10px;
    }

    .form-row {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
    }

    .form-group {
        flex: 1 1 calc(50% - 20px); /* Two columns with spacing */
        min-width: 300px; /* Minimum width for each column */
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: bold;
        color: #555;
    }

    .form-group input, .form-group select {
        width: 100%;
        padding: 12px;
        border-radius: 4px;
        border: 1px solid #ccc;
        box-sizing: border-box;
        font-size: 16px;
        margin-bottom: 10px;
    }

    .form-group input:focus, .form-group select:focus {
        border-color: #007bff;
        outline: none;
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.2);
    }

    .form-group i {
        color: #007bff;
        margin-right: 8px;
    }

    .btn {
        display: block;
        width: 100%;
        padding: 15px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 4px;
        font-size: 16px;
        cursor: pointer;
        transition: background-color 0.3s ease;
        margin-top: 20px;
    }

    .btn:hover {
        background-color: #0056b3;
    }

    .alert {
        padding: 10px;
        border-radius: 4px;
        margin-bottom: 20px;
    }

    .alert.success {
        background-color: #d4edda;
        color: #155724;
    }

    .alert.error {
        background-color: #f8d7da;
        color: #721c24;
    }

    @media (max-width: 768px) {
        .form-group {
            flex: 1 1 100%; /* Stack form groups on smaller screens */
            margin: 5px 0;
        }
    }

</style>
<body>
    <div class="container">
        <h2>Insert Vehicle Record</h2>
        <form action="" method="POST">
            <div class="form-row">
                <div class="form-group">
                    <label for="installation_date"><i class="fas fa-calendar-alt"></i> Installation Date</label>
                    <input type="text" id="installation_date" name="installation_date" placeholder="mm/dd/yyyy" value="<?php echo htmlspecialchars($installation_date); ?>" required>
                </div>
                <div class="form-group">
                    <label for="client_name"><i class="fas fa-user"></i> Client Name</label>
                    <input type="text" id="client_name" name="client_name" value="<?php echo htmlspecialchars($client_name); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="sales_person"><i class="fas fa-user-tie"></i> Sales Person</label>
                    <select id="sales_person" name="sales_person" required>
                        <option value="">Select Sales Person</option>
                        <?php while ($row = $sales_result->fetch_assoc()) { ?>
                            <option value="<?php echo htmlspecialchars($row['phone_number']); ?>" <?php echo ($sales_person == $row['phone_number']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($row['full_name']); ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="vehicle_reg"><i class="fas fa-car"></i> Vehicle Registration</label>
                    <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="model"><i class="fas fa-car-side"></i> Model</label>
                    <input type="text" id="model" name="model" value="<?php echo htmlspecialchars($model); ?>" required>
                </div>
                <div class="form-group">
                    <label for="tracker_number"><i class="fas fa-tag"></i> Tracker Number</label>
                    <input type="text" id="tracker_number" name="tracker_number" value="<?php echo htmlspecialchars($tracker_number); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="contact"><i class="fas fa-phone"></i> Contact</label>
                    <input type="text" id="contact" name="contact" value="<?php echo htmlspecialchars($contact); ?>" required>
                </div>
                <div class="form-group">
                    <label for="bank"><i class="fas fa-dollar-sign"></i> Bank</label>
                    <input type="text" id="bank" name="bank" value="<?php echo htmlspecialchars($bank); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="technician"><i class="fas fa-tools"></i> Technician</label>
                    <select id="technician" name="technician" required>
                        <option value="">Select Technician</option>
                        <?php while ($row = $tech_result->fetch_assoc()) { ?>
                            <option value="<?php echo htmlspecialchars($row['phone_number']); ?>" <?php echo ($technician == $row['phone_number']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($row['full_name']); ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="t_k"><i class="fas fa-calendar-day"></i> T.K</label>
                    <input type="text" id="t_k" name="t_k" value="<?php echo htmlspecialchars($t_k); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="tracksolid"><i class="fas fa-laptop"></i> Tracksolid</label>
                    <input type="text" id="tracksolid" name="tracksolid" value="<?php echo htmlspecialchars($tracksolid); ?>" required>
                </div>
                <div class="form-group">
                    <label for="username"><i class="fas fa-user"></i> Username</label>
                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="password"><i class="fas fa-key"></i> Password</label>
                    <input type="password" id="password" name="password" value="<?php echo htmlspecialchars($password); ?>" required>
                </div>
                <div class="form-group">
                    <label for="loan_duration"><i class="fas fa-calendar"></i> Loan Duration</label>
                    <input type="text" id="loan_duration" name="loan_duration" value="<?php echo htmlspecialchars($loan_duration); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="c_no"><i class="fas fa-hashtag"></i> C/No</label>
                    <input type="text" id="c_no" name="c_no" value="<?php echo htmlspecialchars($c_no); ?>" required>
                </div>
                <div class="form-group">
                    <label for="expiray"><i class="fas fa-calendar-times"></i> Expiry Date</label>
                    <input type="text" id="expiray" name="expiray" placeholder="mm/dd/yyyy" value="<?php echo htmlspecialchars($expiray); ?>" required>
                </div>
            </div>
            <button type="submit" class="btn">Submit</button>
            <a href="dashboard.php" style="display: inline-block; padding: 10px 20px;margin-top:10px; font-size: 16px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
        </form>
    </div>
</body>
</html>
