<?php
// Include database connection file
include 'conn.php';

// Initialize variables
$name = "";
$work_id = "";
$message = "";
$messageClass = "";

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve and escape form data
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $work_id = mysqli_real_escape_string($conn, $_POST['work_id']);

    // Insert the record
    $query = "INSERT INTO salespersons (name, work_id) VALUES ('$name', '$work_id')";

    if (mysqli_query($conn, $query)) {
        $message = "Salesperson added successfully";
        $messageClass = "success";
    } else {
        $message = "Error adding salesperson: " . mysqli_error($conn);
        $messageClass = "error";
    }

    // Close connection
    mysqli_close($conn);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Salesperson</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f8ff;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background-color: #e6f7ff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 100%;
            box-sizing: border-box;
        }
        h2 {
            color: #007acc;
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        label {
            color: #007acc;
            margin-bottom: 5px;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        button {
            width: 100%;
            padding: 10px;
            background-color: #007acc;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #005fa3;
        }
        .message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background-color: #dff0d8; /* Success message background color */
            border: 1px solid #3c763d; /* Success message border color */
            color: #3c763d; /* Success message text color */
            border-radius: 5px;
            display: none; /* Initially hidden */
            z-index: 9999; /* Ensure it's on top */
        }
        .message.error {
            background-color: #f2dede; /* Error message background color */
            border-color: #a94442; /* Error message border color */
            color: #a94442; /* Error message text color */
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var messageElement = document.querySelector('.message');

            <?php if (!empty($message)) { ?>
                showMessage('<?php echo $message; ?>', '<?php echo $messageClass; ?>');
            <?php } ?>

            function showMessage(message, className) {
                messageElement.textContent = message;
                messageElement.classList.add(className);
                messageElement.style.display = 'block';
                setTimeout(function() {
                    messageElement.style.display = 'none';
                    messageElement.classList.remove(className);
                }, 4000); // Hide message after 4 seconds
            }
        });
    </script>
</head>
<body>
    <div class="container">
        <h2>Add Salesperson</h2>
        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
            <div class="form-group">
                <label for="name">Name</label>
                <input type="text" id="name" name="name" required>
            </div>
            <div class="form-group">
                <label for="work_id">Work ID</label>
                <input type="text" id="work_id" name="work_id" required>
            </div>
            <button type="submit">Add Salesperson</button>
            <a href="dashboard.php" style="display: inline-block; padding: 10px 20px; font-size: 16px; text-decoration: none; color: #fff; background-color:brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>

        </form>
    </div>

    <!-- Display message -->
    <div class="message <?php echo $messageClass; ?>"><?php echo $message; ?></div>
</body>
</html>
