<?php
require_once 'config.php';

function getDB() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    return $conn;
}

function insertTransaction($order_id, $amount, $method, $bank, $email, $phone, $user_id) {
    $conn = getDB();
    $stmt = $conn->prepare("INSERT INTO transactions (order_id, amount, payment_method, bank, email, phone, user_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sdssssi", $order_id, $amount, $method, $bank, $email, $phone, $user_id);
    $stmt->execute();
    $stmt->close();
    $conn->close();
}

function updateTransactionStatus($order_id, $status) {
    $conn = getDB();
    $stmt = $conn->prepare("UPDATE transactions SET status = ? WHERE order_id = ?");
    $stmt->bind_param("ss", $status, $order_id);
    $stmt->execute();
    $stmt->close();
    $conn->close();
}

function getPesapalToken() {
    $auth_url = PESAPAL_ENDPOINT . '/api/Auth/RequestToken';
    $auth_data = [
        'consumer_key' => PESAPAL_CONSUMER_KEY,
        'consumer_secret' => PESAPAL_CONSUMER_SECRET
    ];
    $ch = curl_init($auth_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($auth_data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, PESAPAL_IS_LIVE ? true : false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 3);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if (curl_errno($ch)) {
        error_log("getPesapalToken cURL error: " . curl_error($ch), 3, ERROR_LOG_PATH);
        curl_close($ch);
        throw new Exception("Failed to get Pesapal token");
    }
    curl_close($ch);
    $auth_response = json_decode($response, true);
    if ($http_code !== 200 || !isset($auth_response['token'])) {
        error_log("getPesapalToken failed: HTTP $http_code, " . json_encode($auth_response), 3, ERROR_LOG_PATH);
        throw new Exception("Authentication failed: " . ($auth_response['error'] ?? 'Unknown error'));
    }
    return $auth_response['token'];
}
function authenticateUser($username, $password) {
    $conn = getDB();
    $stmt = $conn->prepare("SELECT id, username, email, phone FROM users WHERE username = ? AND password = ?");
    $stmt->bind_param("ss", $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
    $conn->close();
    return $user;
}

function getUserTransactions($user_id) {
    $conn = getDB();
    $stmt = $conn->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $conn->close();
    return $result;
}
?>