<?php
session_start();
require_once 'config.php';
require_once 'database.php';

if (!isset($_SESSION['admin'])) {
    header("Location: admin_login.php");
    exit();
}

// Build filter conditions
$where = [];
$params = [];
$types = '';
if (!empty($_GET['method'])) {
    $where[] = "t.payment_method = ?";
    $params[] = $_GET['method'];
    $types .= 's';
}
if (!empty($_GET['status'])) {
    $where[] = "t.status = ?";
    $params[] = $_GET['status'];
    $types .= 's';
}
if (!empty($_GET['date_from'])) {
    $where[] = "t.created_at >= ?";
    $params[] = $_GET['date_from'];
    $types .= 's';
}
if (!empty($_GET['date_to'])) {
    $where[] = "t.created_at <= ?";
    $params[] = $_GET['date_to'];
    $types .= 's';
}
if (!empty($_GET['username'])) {
    $where[] = "u.username = ?";
    $params[] = $_GET['username'];
    $types .= 's';
}

$where_sql = $where ? " WHERE " . implode(" AND ", $where) : "";

// Fetch analytics data
$conn = getDB();
$sql_total_transactions = "SELECT COUNT(*) as count FROM transactions t JOIN users u ON t.user_id = u.id" . $where_sql;
$sql_total_amount = "SELECT SUM(amount) as total FROM transactions t JOIN users u ON t.user_id = u.id" . $where_sql;
$sql_method_breakdown = "SELECT t.payment_method, COUNT(*) as count, SUM(t.amount) as total FROM transactions t JOIN users u ON t.user_id = u.id" . $where_sql . " GROUP BY t.payment_method";

$stmt_total_transactions = $conn->prepare($sql_total_transactions);
$stmt_total_amount = $conn->prepare($sql_total_amount);
$stmt_method_breakdown = $conn->prepare($sql_method_breakdown);

if ($params) {
    $stmt_total_transactions->bind_param($types, ...$params);
    $stmt_total_amount->bind_param($types, ...$params);
    $stmt_method_breakdown->bind_param($types, ...$params);
}

$stmt_total_transactions->execute();
$total_transactions = $stmt_total_transactions->get_result()->fetch_assoc()['count'];
$stmt_total_transactions->close();

$stmt_total_amount->execute();
$total_amount = $stmt_total_amount->get_result()->fetch_assoc()['total'];
$stmt_total_amount->close();

$stmt_method_breakdown->execute();
$method_breakdown = $stmt_method_breakdown->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_method_breakdown->close();

$conn->close();

// Generate CSV
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="analytics_export_' . date('YmdHis') . '.csv"');

$output = fopen('php://output', 'w');

// Write summary
fputcsv($output, ['Analytics Report', 'Generated on ' . date('Y-m-d H:i:s')]);
fputcsv($output, []);
fputcsv($output, ['Total Transactions', $total_transactions]);
fputcsv($output, ['Total Amount (KES)', number_format($total_amount, 2)]);
fputcsv($output, []);

// Write method breakdown
fputcsv($output, ['Payment Method', 'Transaction Count', 'Total Amount (KES)']);
foreach ($method_breakdown as $method) {
    fputcsv($output, [
        $method['payment_method'],
        $method['count'],
        number_format($method['total'], 2)
    ]);
}
if (empty($method_breakdown)) {
    fputcsv($output, ['No data available for selected filters']);
}

fclose($output);
exit();
?>