<?php
session_start();
require_once 'config.php';
require_once 'database.php';

if (!isset($_SESSION['admin'])) {
    header("Location: admin_login.php");
    exit();
}

$conn = getDB();
$result = $conn->query("SELECT t.order_id, u.username, t.amount, t.payment_method, t.bank, t.email, t.phone, t.status, t.created_at 
                        FROM transactions t JOIN users u ON t.user_id = u.id 
                        ORDER BY t.created_at DESC");

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="transactions_export_' . date('YmdHis') . '.csv"');

$output = fopen('php://output', 'w');
fputcsv($output, ['Order ID', 'Username', 'Amount (KES)', 'Payment Method', 'Bank', 'Email', 'Phone', 'Status', 'Date']);

while ($row = $result->fetch_assoc()) {
    fputcsv($output, [
        $row['order_id'],
        $row['username'],
        number_format($row['amount'], 2),
        $row['payment_method'],
        $row['bank'] ?: '-',
        $row['email'],
        $row['phone'],
        $row['status'],
        date('Y-m-d H:i:s', strtotime($row['created_at']))
    ]);
}

fclose($output);
$conn->close();
exit();
?>