<?php
session_start();
require_once 'config.php';
require_once 'database.php';

// Store form data in session for guests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_SESSION['user_id'])) {
    $_SESSION['pending_payment'] = [
        'amount' => $_POST['amount'],
        'email' => $_POST['email'],
        'phone' => $_POST['phone'],
        'payment_method' => $_POST['payment_method'],
        'bank' => isset($_POST['bank']) ? $_POST['bank'] : null
    ];
    header("Location: user_login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesapal Secure Payment Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); min-height: 100vh; }
        .payment-card { border: none; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); overflow: hidden; }
        .payment-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 2rem; text-align: center; }
        .payment-body { padding: 2.5rem; }
        .form-label { font-weight: 500; color: #333; }
        .form-control, .form-select { border-radius: 10px; border: 2px solid #e9ecef; padding: 0.75rem 1rem; transition: all 0.3s ease; }
        .form-control:focus, .form-select:focus { border-color: #667eea; box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25); }
        .method-option { display: flex; align-items: center; padding: 0.75rem; border-radius: 10px; transition: all 0.3s ease; cursor: pointer; margin-bottom: 0.5rem; }
        .method-option:hover { background: #f8f9fa; }
        .method-option.selected { background: #e3f2fd; border: 2px solid #2196f3; }
        .method-icon { width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 1rem; font-size: 1.2rem; }
        .mpesa { background: #00a651; color: white; }
        .airtel { background: #ff6b35; color: white; }
        .mtn { background: #f28c38; color: white; }
        .card { background: #000; color: white; }
        .pesalink { background: #007bff; color: white; }
        .wallet { background: #6f42c1; color: white; }
        .btn-pay { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; border-radius: 10px; padding: 0.75rem 2rem; font-weight: 600; transition: all 0.3s ease; }
        .btn-pay:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4); }
        .alert-friendly { border-radius: 10px; border: none; background: #e3f2fd; }
        .loading { display: none; text-align: center; padding: 1rem; }
        .spinner { color: #667eea; }
        .sticky-nav { position: sticky; top: 0; z-index: 1000; background: #fff; padding: 1rem; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .modal-content { border-radius: 15px; }
        @media (max-width: 768px) { .payment-body { padding: 1.5rem; } }
    </style>
</head>
<body>
    <div class="container py-4">
        <!-- Navigation -->
        <div class="sticky-nav">
            <div class="d-flex justify-content-between align-items-center">
                <h4><i class="fas fa-user me-2"></i><?php echo isset($_SESSION['username']) ? 'Welcome, ' . htmlspecialchars($_SESSION['username']) : 'Guest'; ?></h4>
                <div>
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <a href="user_dashboard.php" class="btn btn-outline-primary btn-sm me-2"><i class="fas fa-history me-2"></i>My Transactions</a>
                        <a href="user_login.php?logout=1" class="btn btn-outline-danger btn-sm"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
                    <?php else: ?>
                        <a href="user_login.php" class="btn btn-outline-primary btn-sm me-2"><i class="fas fa-sign-in-alt me-2"></i>Login</a>
                        <a href="register.php" class="btn btn-outline-success btn-sm"><i class="fas fa-user-plus me-2"></i>Sign Up</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Payment Form -->
        <div class="row justify-content-center mt-4">
            <div class="col-md-8">
                <div class="payment-card">
                    <div class="payment-header">
                        <i class="fas fa-shield-alt fa-2x mb-2 d-block"></i>
                        <h2 class="mb-1">Secure & Seamless Payments</h2>
                        <p class="mb-0 opacity-75">Pay easily with Pesapal – Your trusted payment partner</p>
                    </div>
                    <div class="payment-body">
                        <form id="paymentForm" action="<?php echo isset($_SESSION['user_id']) ? 'process_payment.php' : ''; ?>" method="POST" class="needs-validation" novalidate>
                            <?php if (isset($_SESSION['user_id'])): ?>
                                <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($_SESSION['user_id']); ?>">
                            <?php endif; ?>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="amount" class="form-label">
                                        <i class="fas fa-money-bill-wave text-primary me-1"></i> Amount (KES)
                                    </label>
                                    <input type="number" class="form-control" id="amount" name="amount" required min="1" placeholder="Enter amount" aria-describedby="amountHelp" value="<?php echo isset($_SESSION['pending_payment']['amount']) ? htmlspecialchars($_SESSION['pending_payment']['amount']) : ''; ?>">
                                    <div class="invalid-feedback">Amount must be at least KES 1.</div>
                                    <div id="amountHelp" class="form-text">Enter the amount you wish to pay.</div>
                                </div>
                                <div class="col-md-6">
                                    <label for="email" class="form-label">
                                        <i class="fas fa-envelope text-primary me-1"></i> Email Address
                                    </label>
                                    <input type="email" class="form-control" id="email" name="email" required value="<?php echo isset($_SESSION['email']) ? htmlspecialchars($_SESSION['email']) : (isset($_SESSION['pending_payment']['email']) ? htmlspecialchars($_SESSION['pending_payment']['email']) : ''); ?>" <?php echo isset($_SESSION['user_id']) ? 'readonly' : ''; ?>>
                                    <div class="invalid-feedback">Please provide a valid email.</div>
                                </div>
                                <div class="col-12">
                                    <label for="phone" class="form-label">
                                        <i class="fas fa-phone text-primary me-1"></i> Phone Number
                                    </label>
                                    <input type="tel" class="form-control" id="phone" name="phone" required pattern="\+?[0-9]{10,12}" value="<?php echo isset($_SESSION['phone']) ? htmlspecialchars($_SESSION['phone']) : (isset($_SESSION['pending_payment']['phone']) ? htmlspecialchars($_SESSION['pending_payment']['phone']) : ''); ?>" <?php echo isset($_SESSION['user_id']) ? 'readonly' : ''; ?>>
                                    <div class="invalid-feedback">Please provide a valid phone number (e.g., +254 7XX XXX XXX).</div>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">
                                        <i class="fas fa-credit-card text-primary me-1"></i> Select Payment Method
                                    </label>
                                    <div class="row g-2">
                                        <div class="col-md-4">
                                            <div class="method-option <?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'M-Pesa' ? 'selected' : ''; ?>" onclick="selectMethod('M-Pesa', this)" data-bs-toggle="tooltip" title="Pay instantly via Safaricom M-Pesa">
                                                <div class="method-icon mpesa"><i class="fas fa-mobile-alt"></i></div>
                                                <div>M-Pesa</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="method-option <?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'Airtel Money' ? 'selected' : ''; ?>" onclick="selectMethod('Airtel Money', this)" data-bs-toggle="tooltip" title="Quick payment with Airtel Money">
                                                <div class="method-icon airtel"><i class="fas fa-mobile-alt"></i></div>
                                                <div>Airtel Money</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="method-option <?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'MTN MoMo' ? 'selected' : ''; ?>" onclick="selectMethod('MTN MoMo', this)" data-bs-toggle="tooltip" title="Secure payment via MTN Mobile Money">
                                                <div class="method-icon mtn"><i class="fas fa-globe-africa"></i></div>
                                                <div>MTN MoMo</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="method-option <?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'Card' ? 'selected' : ''; ?>" onclick="selectMethod('Card', this)" data-bs-toggle="tooltip" title="Pay with Visa, Mastercard, or Amex">
                                                <div class="method-icon card"><i class="fas fa-credit-card"></i></div>
                                                <div>Card Payment</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="method-option <?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'PesaLink' ? 'selected' : ''; ?>" onclick="selectMethod('PesaLink', this)" data-bs-toggle="tooltip" title="Instant bank transfer via PesaLink">
                                                <div class="method-icon pesalink"><i class="fas fa-university"></i></div>
                                                <div>PesaLink</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="method-option <?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'Pesapal Wallet' ? 'selected' : ''; ?>" onclick="selectMethod('Pesapal Wallet', this)" data-bs-toggle="tooltip" title="Use your Pesapal Wallet balance">
                                                <div class="method-icon wallet"><i class="fas fa-wallet"></i></div>
                                                <div>Pesapal Wallet</div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" id="payment_method" name="payment_method" required value="<?php echo isset($_SESSION['pending_payment']['payment_method']) ? htmlspecialchars($_SESSION['pending_payment']['payment_method']) : ''; ?>">
                                    <div class="invalid-feedback">Please select a payment method.</div>
                                </div>
                                <div class="col-12" id="bank_group" style="display:<?php echo isset($_SESSION['pending_payment']['payment_method']) && $_SESSION['pending_payment']['payment_method'] == 'PesaLink' ? 'block' : 'none'; ?>;">
                                    <label for="bank" class="form-label">
                                        <i class="fas fa-building text-primary me-1"></i> Select Bank (for PesaLink)
                                    </label>
                                    <select class="form-select" id="bank" name="bank" data-bs-toggle="tooltip" title="Choose your bank for PesaLink transfer">
                                        <option value="">Select Your Bank</option>
                                        <option value="ABC Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'ABC Bank' ? 'selected' : ''; ?>>ABC Bank</option>
                                        <option value="ABSA Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'ABSA Bank' ? 'selected' : ''; ?>>ABSA Bank (formerly Barclays)</option>
                                        <option value="Bank of Africa" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Bank of Africa' ? 'selected' : ''; ?>>Bank of Africa</option>
                                        <option value="Bank of Baroda" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Bank of Baroda' ? 'selected' : ''; ?>>Bank of Baroda</option>
                                        <option value="Central Bank of Kenya" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Central Bank of Kenya' ? 'selected' : ''; ?>>Central Bank of Kenya</option>
                                        <option value="Co-operative Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Co-operative Bank' ? 'selected' : ''; ?>>Co-operative Bank</option>
                                        <option value="Diamond Trust Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Diamond Trust Bank' ? 'selected' : ''; ?>>Diamond Trust Bank</option>
                                        <option value="Equity Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Equity Bank' ? 'selected' : ''; ?>>Equity Bank</option>
                                        <option value="KCB Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'KCB Bank' ? 'selected' : ''; ?>>KCB Bank</option>
                                        <option value="National Bank of Kenya" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'National Bank of Kenya' ? 'selected' : ''; ?>>National Bank of Kenya</option>
                                        <option value="NCBA Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'NCBA Bank' ? 'selected' : ''; ?>>NCBA Bank (formerly NIC)</option>
                                        <option value="Family Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Family Bank' ? 'selected' : ''; ?>>Family Bank</option>
                                        <option value="Gulf African Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Gulf African Bank' ? 'selected' : ''; ?>>Gulf African Bank</option>
                                        <option value="I&M Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'I&M Bank' ? 'selected' : ''; ?>>I&M Bank</option>
                                        <option value="Kingdom Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Kingdom Bank' ? 'selected' : ''; ?>>Kingdom Bank</option>
                                        <option value="Paramount Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Paramount Bank' ? 'selected' : ''; ?>>Paramount Bank</option>
                                        <option value="Prime Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Prime Bank' ? 'selected' : ''; ?>>Prime Bank</option>
                                        <option value="SBM Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'SBM Bank' ? 'selected' : ''; ?>>SBM Bank</option>
                                        <option value="Stanbic Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Stanbic Bank' ? 'selected' : ''; ?>>Stanbic Bank</option>
                                        <option value="Standard Chartered" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Standard Chartered' ? 'selected' : ''; ?>>Standard Chartered</option>
                                        <option value="United Bank for Africa" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'United Bank for Africa' ? 'selected' : ''; ?>>United Bank for Africa</option>
                                        <option value="Victoria Commercial Bank" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Victoria Commercial Bank' ? 'selected' : ''; ?>>Victoria Commercial Bank</option>
                                        <option value="Sasapay" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'Sasapay' ? 'selected' : ''; ?>>Sasapay (Fintech)</option>
                                        <option value="KWFT" <?php echo isset($_SESSION['pending_payment']['bank']) && $_SESSION['pending_payment']['bank'] == 'KWFT' ? 'selected' : ''; ?>>KWFT (Microfinance)</option>
                                    </select>
                                    <div class="invalid-feedback">Please select a bank for PesaLink.</div>
                                    <div class="form-text">Updated September 2025 – All major banks supported.</div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mt-4">
                                <div class="text-muted small">
                                    <i class="fas fa-lock me-1"></i> Secure • PCI-DSS Compliant
                                </div>
                                <button type="submit" class="btn btn-pay text-white" id="payBtn">
                                    <span class="btn-text"><i class="fas fa-arrow-right me-2"></i> Pay Now</span>
                                    <span class="loading"><i class="fas fa-spinner fa-spin spinner"></i></span>
                                </button>
                            </div>
                        </form>
                        <div class="loading mt-3" id="loading">
                            <i class="fas fa-spinner fa-spin spinner fa-2x"></i>
                            <p class="mt-2">Processing your payment...</p>
                        </div>
                        <div class="alert alert-friendly mt-3" role="alert">
                            <i class="fas fa-info-circle me-2"></i>
                            Need help? <a href="mailto:harronmugo@gmail.com" class="alert-link">Contact Support</a> or call +254 758 788 248.
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-4">
            <small class="text-muted"><i class="fas fa-lock me-1"></i> Secured by Pesapal | Compliant with CBK Regulations</small>
        </div>

        <!-- Login/Signup Modal -->
        <div class="modal fade" id="authModal" tabindex="-1" aria-labelledby="authModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="authModalLabel">Authentication Required</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <p>Please log in or sign up to complete your payment.</p>
                        <a href="user_login.php" class="btn btn-primary me-2"><i class="fas fa-sign-in-alt me-2"></i>Login</a>
                        <a href="register.php" class="btn btn-success"><i class="fas fa-user-plus me-2"></i>Sign Up</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Initialize tooltips
        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
        tooltipTriggerList.forEach(el => new bootstrap.Tooltip(el));

        // Select payment method
        let selectedMethod = '<?php echo isset($_SESSION['pending_payment']['payment_method']) ? htmlspecialchars($_SESSION['pending_payment']['payment_method']) : ''; ?>';
        function selectMethod(method, element) {
            document.querySelectorAll('.method-option').forEach(el => el.classList.remove('selected'));
            element.classList.add('selected');
            selectedMethod = method;
            document.getElementById('payment_method').value = method;
            document.getElementById('bank_group').style.display = (method === 'PesaLink') ? 'block' : 'none';
            document.getElementById('bank').required = (method === 'PesaLink');
        }

        // Form validation and guest prompt
        const form = document.getElementById('paymentForm');
        const payBtn = document.getElementById('payBtn');
        const loading = document.getElementById('loading');
        const authModal = new bootstrap.Modal(document.getElementById('authModal'));
        form.addEventListener('submit', function(e) {
            if (!form.checkValidity() || !selectedMethod) {
                e.preventDefault();
                e.stopPropagation();
                if (!selectedMethod) {
                    alert('Please select a payment method.');
                }
            } else if (!<?php echo isset($_SESSION['user_id']) ? 'true' : 'false'; ?>) {
                e.preventDefault();
                authModal.show();
                return;
            } else {
                payBtn.querySelector('.btn-text').style.display = 'none';
                payBtn.querySelector('.loading').style.display = 'inline-block';
                payBtn.disabled = true;
                loading.style.display = 'block';
            }
            form.classList.add('was-validated');
        });
    </script>
</body>
</html>