<?php
require_once 'config.php';

// Get access token
$auth_url = PESAPAL_ENDPOINT . '/api/Auth/RequestToken';
$auth_data = [
    'consumer_key' => PESAPAL_CONSUMER_KEY,
    'consumer_secret' => PESAPAL_CONSUMER_SECRET
];
$ch = curl_init($auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($auth_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, PESAPAL_IS_LIVE ? true : false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if (curl_errno($ch)) {
    error_log("cURL Error (Auth): " . curl_error($ch), 3, ERROR_LOG_PATH);
    die('Failed to get access token: ' . curl_error($ch));
}
curl_close($ch);

$token_data = json_decode($response, true);
error_log("Auth Response: HTTP $http_code, " . json_encode($token_data), 3, ERROR_LOG_PATH);
if ($http_code !== 200 || !isset($token_data['token'])) {
    error_log("Auth Error: " . json_encode($token_data), 3, ERROR_LOG_PATH);
    die('Failed to get access token: ' . json_encode($token_data));
}
$access_token = $token_data['token'];

// Register IPN
$ipn_url = PESAPAL_ENDPOINT . '/api/URLSetup/RegisterIPN';
$payload = json_encode([
    'url' => 'http://localhost/payment_system/post_payment.php', // Use ngrok for localhost
    'ipn_notification_type' => 'POST'
]);
$ch = curl_init($ipn_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $access_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, PESAPAL_IS_LIVE ? true : false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if (curl_errno($ch)) {
    error_log("cURL Error (IPN Register): " . curl_error($ch), 3, ERROR_LOG_PATH);
    die('Failed to register IPN: ' . curl_error($ch));
}
curl_close($ch);

$ipn_data = json_decode($response, true);
error_log("IPN Registration Response: HTTP $http_code, " . json_encode($ipn_data), 3, ERROR_LOG_PATH);
echo "IPN ID: " . ($ipn_data['ipn_id'] ?? 'Failed: ' . json_encode($ipn_data));
?>