<?php
session_start();

// Generate CSRF token
function generateCsrfToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

// Validate CSRF token
function validateCsrfToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Rate limiting for login attempts
function checkRateLimit($key, $maxAttempts = 5, $timeFrame = 900) { // 15 minutes
    $cacheDir = __DIR__ . '/cache';
    if (!is_dir($cacheDir)) {
        mkdir($cacheDir, 0755, true);
    }
    $file = $cacheDir . '/' . md5($key) . '.txt';
    
    if (!file_exists($file)) {
        file_put_contents($file, json_encode(['attempts' => 0, 'timestamp' => time()]));
    }
    
    $data = json_decode(file_get_contents($file), true);
    $now = time();
    
    if ($now - $data['timestamp'] > $timeFrame) {
        $data = ['attempts' => 0, 'timestamp' => $now];
    }
    
    if ($data['attempts'] >= $maxAttempts) {
        return false; // Rate limit exceeded
    }
    
    $data['attempts']++;
    $data['timestamp'] = $now;
    file_put_contents($file, json_encode($data));
    return true;
}

// Clear rate limit
function clearRateLimit($key) {
    $file = __DIR__ . '/cache/' . md5($key) . '.txt';
    if (file_exists($file)) {
        unlink($file);
    }
}

// Secure session setup
function secureSessionStart() {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    ini_set('session.cookie_secure', 1); // Enforce HTTPS
    session_regenerate_id(true);
}
?>