<?php
session_start();
require_once 'config.php';
require_once 'database.php';

$order_tracking_id = isset($_GET['order_tracking_id']) ? $_GET['order_tracking_id'] : null;

if (!$order_tracking_id) {
    $_SESSION['error'] = "Invalid transaction ID.";
    header("Location: index.php");
    exit();
}

// Fetch transaction status (using direct API call since SDK had issues)
$ch = curl_init(PESAPAL_ENDPOINT . "/api/Transactions/GetTransactionStatus?orderTrackingId=$order_tracking_id");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . getPesapalAccessToken(),
    'Content-Type: application/json'
]);
$response = curl_exec($ch);
curl_close($ch);

$status_response = json_decode($response, true);
$order_id = $status_response['merchant_reference'] ?? null;
$status = $status_response['status'] ?? 'UNKNOWN';

// Fetch transaction details from database
$conn = getDB();
$stmt = $conn->prepare("SELECT t.*, u.username FROM transactions t LEFT JOIN users u ON t.user_id = u.id WHERE t.order_id = ?");
$stmt->bind_param("s", $order_id);
$stmt->execute();
$transaction = $stmt->get_result()->fetch_assoc();
$stmt->close();
$conn->close();

if (!$transaction) {
    $_SESSION['error'] = "Transaction not found.";
    header("Location: index.php");
    exit();
}

// Helper function to get Pesapal access token
function getPesapalAccessToken() {
    $auth_url = PESAPAL_ENDPOINT . '/oauth/v1/generate?grant_type=client_credentials';
    $auth_credentials = base64_encode(PESAPAL_CONSUMER_KEY . ':' . PESAPAL_CONSUMER_SECRET);
    $ch = curl_init($auth_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Basic ' . $auth_credentials,
        'Content-Type: application/json'
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    $auth_data = json_decode($response, true);
    return $auth_data['access_token'] ?? null;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Confirmation - Pesapal Payment System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); min-height: 100vh; }
        .confirmation-card { border: none; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); }
        .confirmation-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 2rem; text-align: center; }
        .confirmation-body { padding: 2.5rem; }
        .status-completed { color: #28a745; }
        .status-pending { color: #ffc107; }
        .status-failed { color: #dc3545; }
        .btn-receipt { background: linear-gradient(135deg, #007bff 0%, #00d4ff 100%); color: white; border-radius: 8px; }
        .btn-receipt:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0, 123, 255, 0.4); }
        @media (max-width: 768px) { .confirmation-body { padding: 1.5rem; } }
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="confirmation-card">
                    <div class="confirmation-header">
                        <h2><i class="fas fa-check-circle me-2"></i>Payment Confirmation</h2>
                        <p class="mb-0 opacity-75">Your transaction details</p>
                    </div>
                    <div class="confirmation-body">
                        <?php if (isset($_SESSION['error'])): ?>
                            <div class="alert alert-danger"><?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div>
                        <?php endif; ?>
                        <h5>Transaction Details</h5>
                        <table class="table table-bordered">
                            <tr><th>Order ID</th><td><?php echo htmlspecialchars($transaction['order_id']); ?></td></tr>
                            <tr><th>Username</th><td><?php echo htmlspecialchars($transaction['username'] ?: 'Guest'); ?></td></tr>
                            <tr><th>Amount (KES)</th><td><?php echo number_format($transaction['amount'], 2); ?></td></tr>
                            <tr><th>Payment Method</th><td><?php echo htmlspecialchars($transaction['payment_method']); ?></td></tr>
                            <tr><th>Bank</th><td><?php echo htmlspecialchars($transaction['bank'] ?: '-'); ?></td></tr>
                            <tr><th>Email</th><td><?php echo htmlspecialchars($transaction['email']); ?></td></tr>
                            <tr><th>Phone</th><td><?php echo htmlspecialchars($transaction['phone']); ?></td></tr>
                            <tr><th>Status</th><td><span class="badge <?php echo $transaction['status'] === 'COMPLETED' ? 'status-completed' : ($transaction['status'] === 'PENDING' ? 'status-pending' : 'status-failed'); ?>"><?php echo htmlspecialchars($transaction['status']); ?></span></td></tr>
                            <tr><th>Date</th><td><?php echo date('M d, Y H:i', strtotime($transaction['created_at'])); ?></td></tr>
                        </table>
                        <div class="text-center">
                            <a href="generate_receipt.php?order_id=<?php echo urlencode($transaction['order_id']); ?>" class="btn btn-receipt"><i class="fas fa-file-pdf me-2"></i>Download Receipt</a>
                            <a href="user_dashboard.php" class="btn btn-outline-primary mt-2"><i class="fas fa-home me-2"></i>Back to Dashboard</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-4">
            <small class="text-muted"><i class="fas fa-lock me-1"></i>Secured by Pesapal | Compliant with CBK Regulations</small>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>