<?php
session_start();
require_once 'config.php';
require_once 'database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: user_login.php");
    exit();
}

$transactions = getUserTransactions($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Dashboard - Pesapal Payment System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); min-height: 100vh; }
        .dashboard-card { border: none; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); }
        .dashboard-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 2rem; text-align: center; }
        .dashboard-body { padding: 2.5rem; }
        .btn-pay { background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border: none; border-radius: 10px; padding: 0.75rem 2rem; }
        .btn-pay:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4); }
        .btn-receipt { background: linear-gradient(135deg, #007bff 0%, #00d4ff 100%); color: white; border-radius: 8px; }
        .btn-receipt:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0, 123, 255, 0.4); }
        .table-responsive { border-radius: 10px; overflow: hidden; }
        .status-pending { color: #ffc107; }
        .status-completed { color: #28a745; }
        .status-failed { color: #dc3545; }
        .sticky-nav { position: sticky; top: 0; z-index: 1000; background: #fff; padding: 1rem; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        @media (max-width: 768px) { .dashboard-body { padding: 1.5rem; } }
    </style>
</head>
<body>
    <div class="container py-4">
        <!-- Navigation -->
        <div class="sticky-nav">
            <div class="d-flex justify-content-between align-items-center">
                <h4><i class="fas fa-user me-2"></i>Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?></h4>
                <div>
                    <a href="index.php" class="btn btn-outline-primary btn-sm me-2"><i class="fas fa-plus me-2"></i>Make Payment</a>
                    <a href="user_login.php?logout=1" class="btn btn-outline-danger btn-sm"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
                </div>
            </div>
        </div>

        <!-- Dashboard Card -->
        <div class="row justify-content-center mt-4">
            <div class="col-md-10">
                <div class="dashboard-card">
                    <div class="dashboard-header">
                        <h2><i class="fas fa-wallet me-2"></i>Your Payment Dashboard</h2>
                        <p class="mb-0 opacity-75">View your transactions and make new payments</p>
                    </div>
                    <div class="dashboard-body">
                        <div class="mb-4">
                            <a href="index.php" class="btn btn-pay text-white"><i class="fas fa-plus me-2"></i>Make a New Payment</a>
                        </div>
                        <h5><i class="fas fa-history me-2"></i>Your Recent Transactions</h5>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Order ID</th>
                                        <th>Amount (KES)</th>
                                        <th>Method</th>
                                        <th>Bank</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Receipt</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($transactions as $txn): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($txn['order_id']); ?></td>
                                            <td><?php echo number_format($txn['amount'], 2); ?></td>
                                            <td><?php echo htmlspecialchars($txn['payment_method']); ?></td>
                                            <td><?php echo htmlspecialchars($txn['bank'] ?: '-'); ?></td>
                                            <td>
                                                <span class="badge bg-light text-dark <?php echo $txn['status'] === 'COMPLETED' ? 'status-completed' : ($txn['status'] === 'PENDING' ? 'status-pending' : 'status-failed'); ?>">
                                                    <?php echo htmlspecialchars($txn['status']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo date('M d, Y H:i', strtotime($txn['created_at'])); ?></td>
                                            <td>
                                                <a href="generate_receipt.php?order_id=<?php echo urlencode($txn['order_id']); ?>" class="btn btn-receipt btn-sm"><i class="fas fa-file-pdf me-2"></i>Download</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <?php if (empty($transactions)): ?>
                                        <tr><td colspan="7" class="text-center">No transactions yet. Make a payment to get started!</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-4">
            <small class="text-muted"><i class="fas fa-lock me-1"></i>Secured by Pesapal | Compliant with CBK Regulations</small>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
