<?php
require_once '../includes/functions.php';

// Security
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    redirect('../auth/login.php');
}

// Current logged-in admin ID
$admin_id = (int)$_SESSION['user_id'];

$success = $error = '';

// Process form
if ($_POST) {
    $name = trim($_POST['name'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $rent_amount = $_POST['rent_amount'] ?? 0;
    $status = $_POST['status'] ?? 'available';

    // Basic validation
    if (empty($name)) {
        $error = "Unit Name is required!";
    } elseif (!is_numeric($rent_amount) || $rent_amount < 0) {
        $error = "Please enter a valid rent amount!";
    } else {
        try {
            // Insert property and assign to current admin
            $stmt = $pdo->prepare("
                INSERT INTO properties 
                (name, address, rent_amount, status, admin_id) 
                VALUES (?, ?, ?, ?, ?)
            ");
            $stmt->execute([$name, $address, $rent_amount, $status, $admin_id]);

            $_SESSION['success'] = "Property <strong>" . htmlspecialchars($name) . "</strong> added successfully!";
            redirect('properties.php');
        } catch (Exception $e) {
            $error = "Failed to add property. Please try again.";
        }
    }
}

include '../includes/header.php';
?>

<!-- BACK TO DASHBOARD BUTTON -->
<div class="mb-4">
    <a href="dashboard.php" class="btn btn-lg btn-dark shadow-sm">
        ← Dashboard
    </a>
</div>

<h2 class="text-success mb-4 fw-bold">Add New Property / Unit</h2>

<a href="properties.php" class="btn btn-secondary mb-3">← Back to Properties</a>

<?php if ($error): ?>
    <div class="alert alert-danger rounded-4 shadow-sm">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<form method="POST" class="row g-3 needs-validation" novalidate>
    <div class="col-md-6">
        <label class="form-label">Unit Name / Number <span class="text-danger">*</span></label>
        <input type="text" name="name" class="form-control form-control-lg" placeholder="e.g. Apartment 3B" required autofocus>
        <div class="invalid-feedback">Please enter a unit name.</div>
    </div>

    <div class="col-md-6">
        <label class="form-label">Monthly Rent (KSh) <span class="text-danger">*</span></label>
        <input type="number" step="0.01" name="rent_amount" class="form-control form-control-lg" placeholder="15000.00" min="0" required>
        <div class="invalid-feedback">Please enter a valid amount.</div>
    </div>

    <div class="col-12">
        <label class="form-label">Full Address (optional)</label>
        <textarea name="address" class="form-control" rows="2" placeholder="e.g. Block A, Ngong Road, Nairobi"></textarea>
    </div>

    <div class="col-md-4">
        <label class="form-label">Initial Status</label>
        <select name="status" class="form-select form-select-lg">
            <option value="available">Available</option>
            <option value="occupied">Occupied</option>
            <option value="maintenance">Under Maintenance</option>
        </select>
    </div>

    <div class="col-12">
        <button type="submit" class="btn btn-success btn-lg px-5 shadow-lg fw-bold">
            Add Property
        </button>
    </div>
</form>

<?php include '../includes/footer.php'; ?>