<?php
// delete_monthly_bill.php
require_once '../includes/functions.php';

if (!isLoggedIn() || ($_SESSION['role'] ?? '') !== 'admin') {
    die('Access denied');
}

$property_id = (int)($_GET['prop'] ?? 0);
$month       = $_GET['month'] ?? ''; // format: YYYY-MM

if ($property_id < 1 || !preg_match('/^\d{4}-\d{2}$/', $month)) {
    $_SESSION['error'] = "Invalid request.";
    redirect('properties.php');
}

$pdo->beginTransaction();
try {
    // 1. Get current rent + garbage fee (fixed parts)
    $stmt = $pdo->prepare("
        SELECT p.rent_amount, COALESCE(s.setting_value, 500) AS garbage_fee
        FROM properties p
        LEFT JOIN settings s ON s.setting_key = 'global_garbage_fee'
        WHERE p.id = ?
    ");
    $stmt->execute([$property_id]);
    $fixed = $stmt->fetch();

    if (!$fixed) throw new Exception("Property not found");

    $base_amount = $fixed['rent_amount'] + (int)$fixed['garbage_fee'];

    // 2. Delete the monthly water record
    $del = $pdo->prepare("DELETE FROM monthly_bills WHERE property_id = ? AND bill_month = ?");
    $deleted = $del->execute([$property_id, $month]);

    if (!$deleted || $del->rowCount() == 0) {
        throw new Exception("No water bill found for that month.");
    }

    // 3. Find active tenant in this property
    $tenant_stmt = $pdo->prepare("SELECT id FROM tenants WHERE property_id = ? AND status = 'active' LIMIT 1");
    $tenant_stmt->execute([$property_id]);
    $tenant = $tenant_stmt->fetch();

    if ($tenant) {
        $tenant_id = $tenant['id'];
        $due_date  = $month . '-01';

        // 4. Re-calculate bill: only rent + garbage (water = 0)
        $update_payment = $pdo->prepare("
            UPDATE payments 
            SET amount = ?
            WHERE tenant_id = ? AND due_date = ?
        ");
        $update_payment->execute([$base_amount, $tenant_id, $due_date]);

        // If payment record doesn't exist yet, create it with base amount
        if ($update_payment->rowCount() == 0) {
            $insert_payment = $pdo->prepare("
                INSERT INTO payments (tenant_id, amount, due_date, status) 
                VALUES (?, ?, ?, 'pending')
            ");
            $insert_payment->execute([$tenant_id, $base_amount, $due_date]);
        }
    }

    $pdo->commit();
    $_SESSION['success'] = "Water bill for " . date('F Y', strtotime($month . '-01')) . " deleted! All reports & payments updated.";

} catch (Exception $e) {
    $pdo->rollBack();
    $_SESSION['error'] = $e->getMessage();
}

redirect("edit_property.php?id=$property_id#monthly-bills");
?>