<?php
require_once '../includes/functions.php';

// Security
if (!isLoggedIn()) {
    exit;
}
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    exit;
}

// Current admin
$admin_id = (int)$_SESSION['user_id'];
$IS_SUPER_ADMIN = ($admin_id === 1); // Change 1 if your main admin has different ID

$prop = (int)($_GET['prop'] ?? 0);
$month = $_GET['month'] ?? '';

if ($prop < 1 || !preg_match('/^\d{4}-\d{2}$/', $month)) {
    $_SESSION['error'] = "Invalid request.";
    redirect('properties.php');
}

// Verify property belongs to this admin
if (!$IS_SUPER_ADMIN) {
    $check = $pdo->prepare("SELECT 1 FROM properties WHERE id = ? AND admin_id = ?");
    $check->execute([$prop, $admin_id]);
    if (!$check->fetch()) {
        $_SESSION['error'] = "Access denied: This is not your property.";
        redirect('properties.php');
    }
}

try {
    $pdo->beginTransaction();

    // Delete the water bill record
    $pdo->prepare("DELETE FROM monthly_bills WHERE property_id = ? AND bill_month = ?")
        ->execute([$prop, $month]);

    // Revert the payment amount to base rent + garbage fee only
    $stmt_tenant = $pdo->prepare("SELECT id FROM tenants WHERE property_id = ? AND status='active'");
    $stmt_tenant->execute([$prop]);
    $tenant = $stmt_tenant->fetch();

    if ($tenant) {
        $rent = $pdo->prepare("SELECT rent_amount FROM properties WHERE id = ?");
        $rent->execute([$prop]);
        $rent_amount = $rent->fetchColumn() ?: 0;

        $garbage_fee = 500;
        try {
            $garbage_fee = $pdo->query("SELECT COALESCE(setting_value, 500) FROM settings WHERE setting_key='global_garbage_fee'")->fetchColumn() ?: 500;
        } catch (Exception $e) {}

        $new_amount = $rent_amount + $garbage_fee;
        $due_date = "$month-01";

        $update_payment = $pdo->prepare("UPDATE payments SET amount = ? WHERE tenant_id = ? AND due_date = ?");
        $update_payment->execute([$new_amount, $tenant['id'], $due_date]);
    }

    $pdo->commit();

    $_SESSION['success'] = "Water bill for " . date('F Y', strtotime("$month-01")) . " deleted and rent reverted successfully.";

} catch (Exception $e) {
    $pdo->rollBack();
    $_SESSION['error'] = "Failed to delete water bill. Please try again.";
}

redirect("edit_property.php?id=$prop#monthly-bills");
?>