<?php
require_once '../includes/functions.php';

// Only logged-in admins can access
if (!isLoggedIn() || ($_SESSION['role'] ?? '') !== 'admin') {
    redirect('../auth/login.php');
}

$success = $error = '';

// Process form submission
if ($_POST) {
    $fee = trim($_POST['garbage_fee'] ?? '');

    // Validate input
    if (!is_numeric($fee) || $fee < 0) {
        $error = "Please enter a valid amount!";
    } else {
        $fee = (float)$fee;

        try {
            $stmt = $pdo->prepare("
                INSERT INTO settings (setting_key, setting_value)
                VALUES ('global_garbage_fee', ?)
                ON DUPLICATE KEY UPDATE setting_value = ?
            ");
            $stmt->execute([$fee, $fee]);

            $success = "Global Garbage Fee updated successfully to <strong>KSh " . number_format($fee) . "</strong>!";
        } catch (Exception $e) {
            $error = "Update failed. Please try again.";
        }
    }
}

// Get current value
try {
    $current = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'global_garbage_fee'")->fetchColumn();
    $current = $current ?: 500;
} catch (Exception $e) {
    $current = 500;
}

include '../includes/header.php';
?>

<div class="container py-5">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="dashboard.php" class="btn btn-dark btn-lg rounded-pill px-5 shadow">
            Back to Dashboard
        </a>
    </div>

    <!-- Page Title -->
    <h1 class="display-6 fw-bold text-success mb-4">System Settings</h1>

    <!-- Success Message -->
    <?php if ($success): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-4 shadow-sm">
            <strong>Success!</strong> <?= $success ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Error Message -->
    <?php if ($error): ?>
        <div class="alert alert-danger rounded-4 shadow-sm">
            <?= htmlspecialchars($error) ?>
        </div>
    <?php endif; ?>

    <!-- Garbage Fee Card -->
    <div class="card border-0 shadow-lg rounded-4 overflow-hidden mb-5">
        <div class="card-header bg-success text-white text-center py-4">
            <h3 class="mb-0 fw-bold">Global Monthly Garbage Fee</h3>
        </div>
        <div class="card-body p-5">
            <form method="POST" class="row g-4 align-items-end">
                <div class="col-lg-8">
                    <label class="form-label fw-bold text-dark fs-5">
                        Garbage Collection Fee (per month)
                    </label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-text bg-light border-0 fw-bold">KSh</span>
                        <input type="number"
                               name="garbage_fee"
                               class="form-control form-control-lg rounded-end"
                               value="<?= htmlspecialchars($current) ?>"
                               min="0"
                               step="1"
                               placeholder="e.g. 300"
                               required
                               autofocus>
                    </div>
                    <small class="text-muted">
                        This amount is <u>automatically added</u> to every tenant's monthly bill
                    </small>
                </div>
                <div class="col-lg-4">
                    <button type="submit" class="btn btn-success btn-lg w-100 rounded-pill shadow-lg fw-bold px-5 py-3">
                        UPDATE FEE
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Info Box -->
    <div class="card border-success bg-light">
        <div class="card-body p-4">
            <h5 class="text-success fw-bold mb-3">How Monthly Billing Works:</h5>
            <div class="bg-white p-4 rounded-4 shadow-sm">
                <p class="mb-2 fs-5">
                    <strong>Total Monthly Bill =</strong><br>
                    Property Rent
                    + Property Water Bill
                    + <span class="text-success fw-bold">Global Garbage Fee (KSh <?= number_format($current) ?>)</span>
                </p>
                <hr>
                <p class="text-muted small">
                    Example: A tenant with KSh 12,000 rent + KSh 800 water =
                    <strong>KSh <?= number_format(12000 + 800 + $current) ?></strong> total
                </p>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="text-center mt-5 py-4 text-muted">
        <p class="mb-0">
            <strong>Rene.C.Agency</strong> • Professional Property Management System
        </p>
        <small>Made with pride in Kenya • <?= date('Y') ?></small>
    </div>
</div>

<?php include '../includes/footer.php'; ?>