<?php
require_once '../includes/functions.php';

// Security
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    redirect('../auth/login.php');
}

// Current admin
$admin_id = (int)$_SESSION['user_id'];
$IS_SUPER_ADMIN = ($admin_id === 1); // Change 1 if your main admin has different ID

// DELETE TENANT (Safe & Filtered by admin)
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];

    // Only delete if tenant belongs to this admin (or super admin)
    if ($IS_SUPER_ADMIN) {
        $stmt = $pdo->prepare("SELECT name FROM tenants t JOIN properties p ON t.property_id = p.id WHERE t.id = ?");
    } else {
        $stmt = $pdo->prepare("SELECT name FROM tenants t JOIN properties p ON t.property_id = p.id WHERE t.id = ? AND p.admin_id = ?");
    }
    $params = $IS_SUPER_ADMIN ? [$id] : [$id, $admin_id];
    $stmt->execute($params);
    $tenant = $stmt->fetchColumn();

    if ($tenant) {
        $pdo->prepare("DELETE FROM tenants WHERE id = ?")->execute([$id]);
        $_SESSION['success'] = "Tenant <strong>" . htmlspecialchars($tenant) . "</strong> deleted permanently.";
    }
    redirect('tenants.php');
}

include '../includes/header.php';
?>

<div class="container py-5">
    <!-- HEADER -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-4 mb-5">
        <a href="dashboard.php" class="btn btn-dark btn-lg rounded-pill px-5 shadow">
            Back to Dashboard
        </a>
        <h1 class="display-6 fw-bold text-success mb-0">Tenants Management</h1>
        <a href="add_tenant.php" class="btn btn-success btn-lg rounded-pill px-5 shadow">
            Add New Tenant
        </a>
    </div>

    <!-- SUCCESS TOAST -->
    <?php if (isset($_SESSION['success'])): ?>
        <div id="successToast" class="position-fixed top-0 start-50 translate-middle-x shadow-lg rounded-4 border-0 overflow-hidden"
             style="z-index: 9999; margin-top: 20px; min-width: 400px;">
            <div class="alert alert-success m-0 py-4 px-5 text-center fw-bold fs-5 text-white"
                 style="background: linear-gradient(135deg, #16a34a, #15803d);">
                <?= $_SESSION['success'] ?>
            </div>
        </div>
        <script>
            setTimeout(() => {
                const t = document.getElementById('successToast');
                if (t) { t.style.transition = 'all 0.7s ease'; t.style.opacity = '0'; t.style.transform = 'translateY(-40px)'; setTimeout(() => t.remove(), 700); }
            }, 6000);
        </script>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <!-- TOTAL TENANTS CARD — FILTERED -->
    <div class="text-center mb-4">
        <h2 class="display-6 text-success">
            Total Tenants: 
            <strong class="text-dark">
                <?php
                if ($IS_SUPER_ADMIN) {
                    echo $pdo->query("SELECT COUNT(*) FROM tenants")->fetchColumn();
                } else {
                    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tenants t JOIN properties p ON t.property_id = p.id WHERE p.admin_id = ?");
                    $stmt->execute([$admin_id]);
                    echo $stmt->fetchColumn();
                }
                ?>
            </strong>
        </h2>
    </div>

    <!-- MAIN TABLE CARD -->
    <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
        <div class="card-header bg-success text-white text-center py-4">
            <h3 class="mb-0 fw-bold">All Registered Tenants</h3>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th class="ps-4">#</th>
                            <th>Tenant Name</th>
                            <th>ID Number</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Property</th>
                            <th>Next of Kin</th>
                            <th>Move-in</th>
                            <th>Status</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($IS_SUPER_ADMIN) {
                            $stmt = $pdo->query("
                                SELECT t.*, p.name AS property_name
                                FROM tenants t
                                LEFT JOIN properties p ON t.property_id = p.id
                                ORDER BY t.name
                            ");
                        } else {
                            $stmt = $pdo->prepare("
                                SELECT t.*, p.name AS property_name
                                FROM tenants t
                                LEFT JOIN properties p ON t.property_id = p.id
                                WHERE p.admin_id = ?
                                ORDER BY t.name
                            ");
                            $stmt->execute([$admin_id]);
                        }

                        $no = 1;
                        while ($t = $stmt->fetch()):
                        ?>
                        <tr class="border-bottom">
                            <td class="ps-4 fw-bold"><?= $no++ ?></td>
                            <td class="fw-bold text-dark"><?= htmlspecialchars($t['name']) ?></td>
                            <td><strong><?= htmlspecialchars($t['id_number'] ?? '—') ?></strong></td>
                            <td>
                                <a href="tel:<?= htmlspecialchars($t['phone']) ?>" class="text-decoration-none">
                                    <?= htmlspecialchars($t['phone'] ?? '—') ?>
                                </a>
                            </td>
                            <td>
                                <?= $t['email']
                                    ? '<a href="mailto:'.htmlspecialchars($t['email']).'" class="text-decoration-none text-primary">'.htmlspecialchars($t['email']).'</a>'
                                    : '<em class="text-muted">—</em>'
                                ?>
                            </td>
                            <td>
                                <span class="badge bg-primary rounded-pill px-3 py-2">
                                    <?= htmlspecialchars($t['property_name'] ?? 'Not Assigned') ?>
                                </span>
                            </td>
                            <td class="text-muted small">
                                <?= htmlspecialchars($t['next_of_kin'] ?? '—') ?>
                                <br>
                                <small><?= htmlspecialchars($t['kin_phone'] ?? '') ?></small>
                            </td>
                            <td><strong><?= date('d M Y', strtotime($t['move_in_date'])) ?></strong></td>
                            <td>
                                <span class="badge rounded-pill px-4 py-2 fs-6 <?= $t['status']=='active' ? 'bg-success' : 'bg-secondary' ?>">
                                    <?= ucfirst($t['status']) ?>
                                </span>
                            </td>
                            <td>
                                <div class="d-flex justify-content-center gap-2">
                                    <a href="edit_tenant.php?id=<?= $t['id'] ?>"
                                       class="btn btn-primary btn-sm rounded-pill px-4 shadow-sm" style="min-width: 80px;">
                                        Edit
                                    </a>
                                    <a href="payments.php?tenant_id=<?= $t['id'] ?>"
                                       class="btn btn-info btn-sm rounded-pill px-4 text-white shadow-sm" style="min-width: 80px;">
                                        Payments
                                    </a>
                                    <a href="tenants.php?delete=<?= $t['id'] ?>"
                                       class="btn btn-danger btn-sm rounded-pill px-4 shadow-sm" style="min-width: 80px;"
                                       onclick="return confirm('⚠️ PERMANENT DELETE\n\nTenant: <?= addslashes(htmlspecialchars($t['name'])) ?>\nID: <?= $t['id_number'] ?? 'N/A' ?>\n\nThis cannot be undone!')">
                                        Delete
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- FOOTER -->
    <div class="text-center mt-5 py-4">
        <p class="mb-0 fw-bold text-success fs-5">Rene.C.Agency</p>
        <small class="text-muted">Professional • Automated • Made in Kenya with Pride</small>
    </div>
</div>

<?php include '../includes/footer.php'; ?>