<?php
session_start();

// Redirect if already logged in
if (isset($_SESSION['user_id']) && isset($_SESSION['role']) && $_SESSION['role'] === 'admin') {
    header("Location: ../admin/dashboard.php");
    exit;
}
if (isset($_SESSION['tenant_id'])) {
    header("Location: ../tenant/dashboard.php");
    exit;
}

$error = '';

if ($_POST) {
    $input1 = trim($_POST['input1'] ?? '');
    $input2 = trim($_POST['input2'] ?? '');

    if ($input1 && $input2) {
        try {
            $pdo = new PDO("mysql:host=localhost;dbname=rantovpw_rene_agency", "rantovpw_agency", "Agency2025#");
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (Exception $e) {
            $error = "Database connection issue.";
        }

        if (!$error) {
            // ADMIN LOGIN — BOTH USERNAME AND PASSWORD ARE NOW CASE-SENSITIVE
            $stmt = $pdo->prepare("SELECT id, username, role FROM users WHERE BINARY username = ? AND BINARY password = ?");
            $stmt->execute([$input1, $input2]);
            $user = $stmt->fetch();

            if ($user && $user['role'] === 'admin') {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['role'] = 'admin';
                header("Location: ../admin/dashboard.php");
                exit;
            }

            // TENANT LOGIN (phone & ID — remains case-insensitive)
            $stmt = $pdo->prepare("SELECT id, name FROM tenants WHERE phone = ? AND id_number = ?");
            $stmt->execute([$input1, $input2]);
            $tenant = $stmt->fetch();

            if ($tenant) {
                $_SESSION['tenant_id'] = $tenant['id'];
                $_SESSION['tenant_name'] = $tenant['name'];
                header("Location: ../tenant/dashboard.php");
                exit;
            }

            $error = "Invalid username or password.";
        }
    } else {
        $error = "Please fill both fields.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login • Rene.C.Agency</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {font-family:'Poppins',sans-serif;background:linear-gradient(135deg,#a8edea,#fed6e3);min-height:100vh;display:flex;align-items:center;justify-content:center;}
        .login-card {background:white;border-radius:30px;box-shadow:0 30px 70px rgba(0,0,0,0.18);max-width:480px;width:100%;overflow:hidden;}
        .logo-section {background:linear-gradient(135deg,#2ecc71,#27ae60);padding:40px 30px 60px;text-align:center;}
        .logo-img {width:140px;height:140px;border-radius:50%;border:8px solid white;box-shadow:0 15px 35px rgba(0,0,0,0.3);background:white;}
        .title {color:white;font-weight:700;margin-top:20px;font-size:28px;}
        .form-section {padding:60px 45px 45px;margin-top:-50px;background:white;border-radius:30px;}
        .form-control {border-radius:16px;padding:16px 20px;border:2px solid #eee;}
        .btn-login {background:linear-gradient(135deg,#2ecc71,#27ae60);color:white;padding:16px;border-radius:16px;font-weight:700;width:100%;box-shadow:0 10px 30px rgba(46,204,113,0.4);}
        .footer {text-align:center;margin-top:30px;color:#666;}
    </style>
</head>
<body>
<div class="login-card">
    <div class="logo-section">
        <img src="../assets/images/rene.png" alt="Logo" class="logo-img">
        <div class="title">Rene.C.Agency</div>
        <div class="subtitle">LOGIN</div>
    </div>
    <div class="form-section">
        <?php if ($error): ?>
            <div class="alert alert-danger rounded-4 text-center py-3 mb-4"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-4">
                <label class="form-label fw-semibold">Username or Phone Number</label>
                <input type="text" name="input1" class="form-control" placeholder="e.g. Admin123 or 0712345678" required autofocus>
            </div>
            <div class="mb-4">
                <label class="form-label fw-semibold">Password or ID Number</label>
                <input type="text" name="input2" class="form-control" placeholder="password or ID number" required>
            </div>
            <button type="submit" class="btn btn-login">SIGN IN</button>
        </form>
        
        <div class="footer">© <?= date('Y') ?> Rene.C.Agency • Proudly Kenyan</div>
    </div>
</div>
</body>
</html>