<?php
// public_html/rene/index.php  ← FINAL VERSION THAT WILL WORK 100% RIGHT NOW
session_start();

// DO NOT require functions.php here — it’s causing the crash
// Just check if user is logged in using raw session (safe & fast)

if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: admin/dashboard.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rene.C.Agency - Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
        }
        .card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            overflow: hidden;
            width: 420px;
            max-width: 95%;
        }
        .header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        .logo {
            width: 90px; height: 90px; background: white; color: #667eea;
            border-radius: 50%; margin: 0 auto 15px;
            display: flex; align-items: center; justify-content: center;
            font-weight: bold; font-size: 36px;
        }
        .body { padding: 40px; text-align: center; }
        .btn-login {
            background: #667eea; color: white; border: none;
            padding: 14px 50px; border-radius: 50px; font-weight: 600;
            font-size: 17px; text-transform: uppercase;
        }
        .btn-login:hover { background: #5a6fd8; }
    </style>
</head>
<body>

<div class="card">
    <div class="header">
        <div class="logo">R.C</div>
        <h3>Rene.C.Agency</h3>
        <p>Smart Rent Payment System</p>
    </div>
    <div class="body">
        <h5>Welcome Back!</h5>
        <p class="text-muted">Login to manage tenants & payments</p>
        <a href="auth/login.php" class="btn btn-login">Login to Dashboard</a>
        <hr>
        <small class="text-muted">© <?= date('Y') ?> Rene.C.Agency • Made in Kenya</small>
    </div>
</div>

</body>
</html>