<?php
session_start();
if (!isset($_SESSION['tenant_id'])) die("Access denied");

require_once '../includes/functions.php';
$tenant_id = $_SESSION['tenant_id'];
$format = $_GET['format'] ?? 'csv';

$sql = "SELECT * FROM payments WHERE tenant_id = ? ";
$params = [$tenant_id];
// Add same filters as reports.php...
if ($_GET['from']) { $sql .= "AND due_date >= ? "; $params[] = $_GET['from']; }
if ($_GET['to']) { $sql .= "AND due_date <= ? "; $params[] = $_GET['to']; }
if ($_GET['status'] && $_GET['status'] !== 'all') { $sql .= "AND status = ? "; $params[] = $_GET['status']; }
$sql .= "ORDER BY due_date DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$data = $stmt->fetchAll();

if ($format === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="payment_report.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Date', 'Amount', 'Due Date', 'Status', 'Notes']);
    foreach ($data as $row) {
        fputcsv($out, [
            date('d/m/Y', strtotime($row['created_at']??$row['due_date'])),
            $row['amount'],
            date('d/m/Y', strtotime($row['due_date'])),
            $row['status'],
            $row['notes'] ?? ''
        ]);
    }
    exit;
}