<?php
session_start();

if (!isset($_SESSION['tenant_id'])) {
    header("Location: login.php");
    exit;
}

$tenant_id = $_SESSION['tenant_id'];

// DATABASE CONNECTION (Your Truehost Details)
$dbname = "rantovpw_rene_agency";
$dbuser = "rantovpw_agency";
$dbpass = "Agency2025#";

try {
    $pdo = new PDO("mysql:host=localhost;dbname=$dbname;charset=utf8mb4", $dbuser, $dbpass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("<h3 class='text-center text-danger mt-5'>Database connection failed. Please contact admin.</h3>");
}

// Get Tenant Name
$tenant_name = $pdo->prepare("SELECT name FROM tenants WHERE id = ?");
$tenant_name->execute([$tenant_id]);
$tenant_name = $tenant_name->fetchColumn() ?: "Tenant";

// Filters
$from   = $_GET['from'] ?? '';
$to     = $_GET['to'] ?? '';
$status = $_GET['status'] ?? 'all';

$sql = "SELECT * FROM payments WHERE tenant_id = ? ";
$params = [$tenant_id];

if ($from) { $sql .= "AND due_date >= ? "; $params[] = $from . '-01'; }
if ($to)   { $sql .= "AND due_date <= ? "; $params[] = $to . '-31'; }
if ($status !== 'all') { $sql .= "AND status = ? "; $params[] = $status; }

$sql .= "ORDER BY due_date DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$payments = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Payment Report • <?= htmlspecialchars($tenant_name) ?> | Rene.C.Agency</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/dist/tabler-icons.min.css">
    <style>
        :root {
            --primary: #6366f1;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --dark: #1e293b;
            --light: #f8fafc;
        }
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #1e293b;
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.18);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            border: 1px solid rgba(255, 255, 255, 0.25);
            box-shadow: 0 20px 50px rgba(0,0,0,0.2);
        }
        .header-gradient {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            color: white;
        }
        .filter-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.12);
        }
        .btn-glow {
            border-radius: 50px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }
        .btn-glow:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.25);
        }
        .table-modern {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 40px rgba(0,0,0,0.12);
        }
        .table-modern thead {
            background: linear-gradient(135deg, #1e293b, #334155);
            color: white;
        }
        .badge-status {
            padding: 0.6em 1.2em;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.9rem;
        }
        .export-btn {
            border-radius: 50px;
            padding: 12px 28px;
            font-weight: 600;
        }
        .footer-text { color: rgba(255,255,255,0.8); }
    </style>
</head>
<body>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-xl-11 col-lg-12">

            <!-- Luxury Header -->
            <div class="header-gradient rounded-4 shadow-lg mb-5 text-center py-5">
                <h1 class="display-4 fw-bold mb-3">
                    <i class="ti ti-file-analytics fs-1 me-3"></i>
                    My Payment Report
                </h1>
                <p class="lead mb-0 opacity-90">
                    <strong><?= htmlspecialchars($tenant_name) ?></strong> • All your rent transactions in one place
                </p>
            </div>

            <!-- Filter Card -->
            <div class="filter-card p-4 mb-5">
                <form method="GET" class="row g-3 align-items-end">
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-bold text-primary">From Month</label>
                        <input type="month" name="from" class="form-control form-control-lg" value="<?= htmlspecialchars($from) ?>">
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-bold text-primary">To Month</label>
                        <input type="month" name="to" class="form-control form-control-lg" value="<?= htmlspecialchars($to) ?>">
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <label class="form-label fw-bold text-primary">Status</label>
                        <select name="status" class="form-select form-select-lg">
                            <option value="all" <?= $status=='all'?'selected':'' ?>>All Payments</option>
                            <option value="paid" <?= $status=='paid'?'selected':'' ?>>Paid Only</option>
                            <option value="pending" <?= $status=='pending'?'selected':'' ?>>Pending Only</option>
                            <option value="partial" <?= $status=='partial'?'selected':'' ?>>Partial</option>
                        </select>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <button type="submit" class="btn btn-success btn-lg w-100 btn-glow">
                            <i class="ti ti-filter me-2"></i> Apply Filter
                        </button>
                    </div>
                </form>
            </div>

            <!-- Export Buttons -->
            <div class="text-end mb-4">
                <a href="export.php?format=csv&tenant_id=<?= $tenant_id ?>&<?= http_build_query($_GET) ?>" 
                   class="btn btn-outline-success export-btn me-3">
                    <i class="ti ti-download"></i> Download CSV
                </a>
                <a href="export.php?format=excel&tenant_id=<?= $tenant_id ?>&<?= http_build_query($_GET) ?>" 
                   class="btn btn-success export-btn">
                    <i class="ti ti-file-spreadsheet"></i> Download Excel
                </a>
            </div>

            <!-- Payments Table -->
            <div class="table-modern">
                <div class="p-4 bg-white border-bottom">
                    <h3 class="fw-bold mb-0">
                        <i class="ti ti-list-details me-2"></i>
                        Payment History <?= $from || $to ? "($from to $to)" : "(All Time)" ?>
                    </h3>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead>
                            <tr>
                                <th class="ps-4">Month</th>
                                <th class="text-end">Billed Amount</th>
                                <th class="text-end">Paid Amount</th>
                                <th class="text-end">Credit Used</th>
                                <th class="text-center">Balance</th>
                                <th class="text-center">Status</th>
                                <th class="pe-4">Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($payments) > 0): ?>
                                <?php foreach ($payments as $p): 
                                    $credit_used = min($p['credit_carried'] ?? 0, max(0, $p['amount'] - $p['amount_paid']));
                                    $balance = $p['amount'] - $p['amount_paid'] - $credit_used;
                                ?>
                                <tr class="<?= $balance > 0 ? 'table-warning' : '' ?>">
                                    <td class="ps-4 fw-600"><?= date('F Y', strtotime($p['due_date'])) ?></td>
                                    <td class="text-end fw-bold">KSh <?= number_format($p['amount']) ?></td>
                                    <td class="text-end text-success fw-bold">KSh <?= number_format($p['amount_paid']) ?></td>
                                    <td class="text-end text-info"><?= $credit_used > 0 ? 'KSh '.number_format($credit_used) : '—' ?></td>
                                    <td class="text-center fw-bold <?= $balance > 0 ? 'text-danger' : 'text-success' ?>">
                                        <?= $balance > 0 ? 'KSh '.number_format($balance) : 'Cleared' ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge-status <?= $balance > 0 ? 'bg-danger' : 'bg-success' ?>">
                                            <?= $balance > 0 ? 'OWES' : 'PAID' ?>
                                        </span>
                                    </td>
                                    <td class="pe-4 text-muted small">
                                        <?= htmlspecialchars($p['notes'] ?? '—') ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="text-center py-5">
                                        <div class="py-5">
                                            <i class="ti ti-file-off fs-1 text-muted mb-3"></i>
                                            <h5 class="text-muted">No payments found for selected filters</h5>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Back Buttons -->
            <div class="text-center mt-5">
                <a href="dashboard.php" class="btn btn-dark btn-lg rounded-pill px-5 btn-glow me-3">
                    <i class="ti ti-arrow-left"></i> Back to Dashboard
                </a>
                <a href="logout.php" class="btn btn-outline-light btn-lg rounded-pill px-5">
                    <i class="ti ti-logout"></i> Logout
                </a>
            </div>

            <!-- Footer -->
            <div class="text-center mt-5 footer-text">
                <p class="mb-0">
                    <strong>Rene.C.Agency</strong> • Professional & Transparent Rent Management • 
                    <script>document.write(new Date().getFullYear())</script>
                </p>
            </div>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>