<?php
// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "school_db";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Fetch dynamic content (e.g., mission statement)
    $stmt = $conn->query("SELECT mission_statement FROM about_page WHERE id = 1");
    $mission = $stmt->fetch(PDO::FETCH_ASSOC)['mission_statement'] ?? "We strive to provide a holistic education that prepares students for success in a global society.";
} catch(PDOException $e) {
    // Log error to file instead of displaying it
    error_log("Connection failed: " . $e->getMessage());
    $mission = "We strive to provide a holistic education that prepares students for success in a global society.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Learn about Gakero E.L.C.K High School, our history, mission, and state-of-the-art facilities in Knowledge City.">
    <meta name="keywords" content="Gakero E.L.C.K High School, education, Knowledge City, secondary school">
    <meta name="author" content="Gakero E.L.C.K High School">
    <title>About - Gakero E.L.C.K High School</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary sticky-top" aria-label="Main navigation">
        <div class="container">
            <a class="navbar-brand" href="index.php">Gakero E.L.C.K High School</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="student_dashboard.php">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="about.php" aria-current="page">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="news.php">News</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section bg-primary text-white text-center py-5">
        <div class="container">
            <h1 class="display-4">About Us</h1>
            <p class="lead">Discover the legacy and vision of Gakero E.L.C.K High School</p>
        </div>
    </section>

    <!-- About Section -->
    <div class="container my-5 about-section">
        <div class="row g-4">
            <div class="col-md-8">
                <h2 class="section-title">Our History</h2>
                <p>Founded in 1980, Gakero E.L.C.K High School has been a cornerstone of educational excellence in Knowledge City. Our commitment to fostering intellectual growth and personal development has shaped generations of leaders.</p>
                
                <h2 class="section-title">Our Mission</h2>
                <p><?php echo htmlspecialchars($mission); ?></p>
                
                <h2 class="section-title">Our Facilities</h2>
                <ul class="facility-list">
                    <li>State-of-the-art science laboratories</li>
                    <li>Modern computer labs with high-speed internet</li>
                    <li>Extensive sports facilities including a gymnasium</li>
                    <li>Well-stocked library with digital resources</li>
                </ul>
            </div>
            <div class="col-md-4">
                <img src="images/front_view.jpg" alt="Gakero E.L.C.K High School front building view" class="img-fluid about-img" loading="lazy">
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white text-center py-4">
        <div class="container">
            <p>&copy; <?php echo date("Y"); ?> Gakero E.L.C.K High School. All rights reserved.</p>
            <p>Kisii County, Gucha Sub-cunty,Misesi Location</p>
            <p>Email: <a href="mailto:info@gakeroelckhigh.edu" class="text-white">info@gakeroelckhigh.edu</a> | Phone: <a href="tel:+1234567890" class="text-white">(123) 456-7890</a></p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>