<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['student_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "school_db";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit();
}

// Handle timetable deletion
if (isset($_POST['timetable_id'])) {
    $timetable_id = $_POST['timetable_id'];
    $stmt = $conn->prepare("DELETE FROM timetables WHERE id = ?");
    $stmt->execute([$timetable_id]);
}

// Redirect back to timetable page
header("Location: timetable.php");
exit();
?>