<?php
session_start(); // Start session to check login status

// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "school_db";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    error_log("Connection failed: " . $e->getMessage()); // Log error instead of echoing
    $error = "Connection failed. Please try again later.";
}

// Generate CSRF token for logout (if needed)
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];

// Handle logout
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['logout']) && $_POST['csrf_token'] === $csrf_token) {
    session_unset();
    session_destroy();
    header("Location: index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Welcome to Gakero E.L.C.K High School, empowering future leaders with quality education.">
    <meta name="keywords" content="Gakero E.L.C.K High School, education, high school, student portal">
    <meta name="author" content="Gakero E.L.C.K High School">
    <title>Gakero E.L.C.K High School</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        /* Global Styles */
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f6f5;
        }

        /* Hero Section */
        .hero-section {
            background: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url('images/front_view.jpg') no-repeat center center;
            background-size: cover;
            color: #fff;
            padding: 120px 0;
            text-align: center;
            position: relative;
        }
        .hero-section h1 {
            font-size: 3rem;
            font-weight: 600;
            margin-bottom: 1rem;
        }
        .hero-section p {
            font-size: 1.25rem;
            margin-bottom: 1.5rem;
        }
        .hero-section .btn {
            padding: 12px 24px;
            font-size: 1.1rem;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }
        .hero-section .btn:hover {
            transform: translateY(-2px);
            background-color: #005f73;
        }

        /* Navbar */
        .navbar {
            background-color: #003087;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            z-index: 1000;
        }
        .navbar-brand, .nav-link {
            color: #fff !important;
            font-weight: 400;
            transition: color 0.3s ease;
        }
        .nav-link:hover {
            color: #a9d6e5 !important;
        }

        /* Cards (News, Staff, Achievements, Reasons) */
        .news-card, .staff-card, .achievement-card, .reason-card {
            background-color: #fff;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .news-card:hover, .staff-card:hover, .achievement-card:hover, .reason-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
        .staff-card img {
            width: 100%;
            height: 180px;
            object-fit: cover;
            border-radius: 8px;
            margin-bottom: 15px;
        }
        .staff-card p, .news-card p, .achievement-card p, .reason-card p {
            font-size: 0.95rem;
            color: #555;
        }

        /* Carousel */
        .carousel-item img {
            height: 450px;
            object-fit: cover;
            border-radius: 12px;
        }
        .carousel-caption {
            background: rgba(0, 0, 0, 0.6);
            border-radius: 8px;
            padding: 15px;
        }
        .carousel-control-prev, .carousel-control-next {
            filter: invert(100%);
        }

        /* Gallery */
        .gallery-img {
            height: 220px;
            object-fit: cover;
            border-radius: 12px;
            width: 100%;
            transition: transform 0.3s ease;
        }
        .gallery-img:hover {
            transform: scale(1.05);
        }

        /* Section Headings */
        h2 {
            font-size: 2.25rem;
            font-weight: 600;
            color: #003087;
            margin-bottom: 2rem;
            text-align: center;
        }

        /* Footer */
        footer {
            background-color: #003087;
            color: #fff;
            padding: 2rem 0;
        }
        footer p {
            margin: 0;
            font-size: 0.9rem;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .hero-section {
                padding: 80px 0;
            }
            .hero-section h1 {
                font-size: 2.25rem;
            }
            .carousel-item img {
                height: 300px;
            }
            .gallery-img {
                height: 180px;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation (Sticky) -->
    <nav class="navbar navbar-expand-lg navbar-dark sticky-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">Gakero E.L.C.K High School</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="student_dashboard.php">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="news.php">News</a>
                    </li>
                    <?php if (isset($_SESSION['student_id']) && ($_SESSION['role'] === 'student' || $_SESSION['role'] === 'admin')): ?>
                        <li class="nav-item">
                            <form method="POST" action="index.php" style="display:inline;">
                                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                                <button type="submit" name="logout" class="nav-link btn btn-link text-white">Logout</button>
                            </form>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="student_login.php">Login</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <div class="hero-section">
        <div class="container">
            <h1>Welcome to Gakero E.L.C.K High School</h1>
            <p>Empowering Future Leaders with Quality Education</p>
            <a href="about.php" class="btn btn-light btn-lg">Learn More</a>
        </div>
    </div>

    <!-- Advertisements (Carousel) -->
    <div class="container my-5">
        <h2 class="text-center mb-4">Upcoming Events & Programs</h2>
        <div id="advertCarousel" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img src="images/class_2.jpg" class="d-block w-100" alt="Science Fair">
                    <div class="carousel-caption d-none d-md-block">
                        <h5>Annual Science Fair</h5>
                        <p>Join us on August 10, 2025, to explore student innovations!</p>
                    </div>
                </div>
                <div class="carousel-item">
                    <img src="images/sports.jpg" class="d-block w-100" alt="Sports Day">
                    <div class="carousel-caption d-none d-md-block">
                        <h5>Sports Day</h5>
                        <p>Cheer for our athletes on August 15, 2025!</p>
                    </div>
                </div>
                <div class="carousel-item">
                    <img src="images/class.jpg" class="d-block w-100" alt="Art Exhibition">
                    <div class="carousel-caption d-none d-md-block">
                        <h5>Art Exhibition</h5>
                        <p>Discover student creativity on September 1, 2025!</p>
                    </div>
                </div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#advertCarousel" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#advertCarousel" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    </div>

    <!-- School Images (Gallery) -->
    <div class="container my-5">
        <h2 class="text-center mb-4">Our Campus</h2>
        <div class="row">
            <div class="col-md-4 mb-3">
                <img src="images/group.jpg" class="gallery-img w-100" alt="Library">
            </div>
            <div class="col-md-4 mb-3">
                <img src="images/staff2.jpg" class="gallery-img w-100" alt="Classroom">
            </div>
            <div class="col-md-4 mb-3">
                <img src="images/front_view.jpg" class="gallery-img w-100" alt="Sports Field">
            </div>
        </div>
    </div>

    <!-- Staff Profiles -->
    <div class="container my-5">
        <h2 class="text-center mb-4">Meet Our Staff</h2>
        <div class="row">
            <div class="col-md-4 staff-card">
                <img src="images/staff.jpg" class="staff-img" alt="John Doe">
                <h5>John Doe</h5>
                <p><strong>Principal</strong></p>
                <p>With over 20 years of experience in education, Mr. Doe leads our school with a vision for academic excellence.</p>
            </div>
            <div class="col-md-4 staff-card">
                <img src="images/staff.jpg" class="staff-img" alt="Jane Smith">
                <h5>Jane Smith</h5>
                <p><strong>Math Teacher</strong></p>
                <p>Ms. Smith specializes in making math engaging and accessible, with a passion for student success.</p>
            </div>
            <div class="col-md-4 staff-card">
                <img src="images/staff.jpg" class="staff-img" alt="Emily Brown">
                <h5>Emily Brown</h5>
                <p><strong>Science Teacher</strong></p>
                <p>Dr. Brown brings innovative teaching methods to inspire curiosity in science.</p>
            </div>
        </div>
    </div>

    <!-- Achievements -->
    <div class="container my-5">
        <h2 class="text-center mb-4">Our Achievements</h2>
        <div class="row">
            <div class="col-md-4 achievement-card">
                <h5>National Science Award 2024</h5>
                <p>Our students won first place in the National Science Fair for innovative projects.</p>
            </div>
            <div class="col-md-4 achievement-card">
                <h5>State Football Champions 2023</h5>
                <p>Our football team secured the state championship title.</p>
            </div>
            <div class="col-md-4 achievement-card">
                <h5>Top Academic Performance</h5>
                <p>Ranked in the top 5% of schools for academic excellence in 2024.</p>
            </div>
        </div>
    </div>

    <!-- Reasons to Choose -->
    <div class="container my-5">
        <h2 class="text-center mb-4">Why Choose Gakero E.L.C.K High School?</h2>
        <div class="row">
            <div class="col-md-4 reason-card">
                <h5>Expert Faculty</h5>
                <p>Our dedicated teachers are leaders in their fields, ensuring top-quality education.</p>
            </div>
            <div class="col-md-4 reason-card">
                <h5>Modern Facilities</h5>
                <p>State-of-the-art classrooms, labs, and sports facilities enhance learning.</p>
            </div>
            <div class="col-md-4 reason-card">
                <h5>Holistic Development</h5>
                <p>We focus on academics, sports, arts, and leadership to nurture well-rounded students.</p>
            </div>
        </div>
    </div>

    <!-- Main Content (About and News) -->
    <div class="container my-5">
        <div class="row">
            <div class="col-md-6">
                <h2>About Our School</h2>
                <p>Gakero E.L.C.K High School is dedicated to providing excellence in education since 1980. We offer a comprehensive curriculum with a focus on academic excellence, sports, and extracurricular activities.</p>
                <a href="about.php" class="btn btn-primary">Read More</a>
            </div>
            <div class="col-md-6">
                <h2>Latest News</h2>
                <?php
                if (isset($error)) {
                    echo "<div class='alert alert-danger alert-dismissible fade show' role='alert'>";
                    echo htmlspecialchars($error);
                    echo "<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>";
                    echo "</div>";
                }
                $stmt = $conn->query("SELECT * FROM news ORDER BY date_posted DESC LIMIT 2");
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    echo "<div class='news-card'>";
                    echo "<h5>" . htmlspecialchars($row['title']) . "</h5>";
                    echo "<p>" . htmlspecialchars(substr($row['content'], 0, 100)) . "...</p>";
                    echo "<small>Posted on: " . date('F j, Y', strtotime($row['date_posted'])) . "</small>";
                    echo "</div>";
                }
                ?>
                <a href="news.php" class="btn btn-primary">View All News</a>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white text-center py-3">
        <div class="container">
            <p>&copy; <?php echo date("Y"); ?> Gakero E.L.C.K High School. All rights reserved.</p>
            <p>Kisii County, Gucha Sub-cunty,Misesi Location</p>
            <p>Email: <a href="mailto:info@gakeroelckhigh.edu" class="text-white">info@gakeroelckhigh.edu</a> | Phone: <a href="tel:+1234567890" class="text-white">(123) 456-7890</a></p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>