<?php
require_once 'config.php';

function getPesapalToken() {
    $url = (PESAPAL_ENV === 'sandbox' ? 'https://cybqa.pesapal.com/pesapaldemo/api/Auth/RequestToken' : 'https://www.pesapal.com/api/Auth/RequestToken');
    $headers = [
        'Content-Type: application/json',
        'Accept: application/json'
    ];
    $data = json_encode([
        'consumer_key' => PESAPAL_CONSUMER_KEY,
        'consumer_secret' => PESAPAL_CONSUMER_SECRET
    ]);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $response = json_decode($response, true);
    return $response['token'] ?? null;
}

function submitPesapalOrder($token, $amount, $description, $reference, $first_name, $last_name, $email, $phone) {
    $url = (PESAPAL_ENV === 'sandbox' ? 'https://cybqa.pesapal.com/pesapaldemo/api/Transactions/SubmitOrderRequest' : 'https://www.pesapal.com/api/Transactions/SubmitOrderRequest');
    $headers = [
        'Content-Type: application/json',
        'Accept: application/json',
        'Authorization: Bearer ' . $token
    ];
    $data = json_encode([
        'id' => uniqid(),
        'currency' => CURRENCY,
        'amount' => $amount,
        'description' => $description,
        'callback_url' => PESAPAL_CALLBACK_URL . '?ref=' . $reference,
        'redirect_mode' => '',
        'notification_id' => PESAPAL_NOTIFICATION_ID,
        'branch' => 'Main Branch',
        'billing_address' => [
            'email_address' => $email,
            'phone_number' => $phone,
            'country_code' => 'KE',
            'first_name' => $first_name,
            'middle_name' => '',
            'last_name' => $last_name,
            'line_1' => '',
            'line_2' => '',
            'city' => '',
            'state' => '',
            'postal_code' => '',
            'zip_code' => ''
        ]
    ]);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $response = json_decode($response, true);
    return $response['redirect_url'] ?? null;
}

function getTransactionStatus($token, $orderTrackingId) {
    $url = (PESAPAL_ENV === 'sandbox' ? 'https://cybqa.pesapal.com/pesapaldemo/api/Transactions/GetTransactionStatus?orderTrackingId=' . $orderTrackingId : 'https://www.pesapal.com/api/Transactions/GetTransactionStatus?orderTrackingId=' . $orderTrackingId);
    $headers = [
        'Accept: application/json',
        'Authorization: Bearer ' . $token
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $response = json_decode($response, true);
    return $response;
}
?>