<?php
// db.php - Database connection and shared functions
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "vehicle_tracking_system";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
} catch (Exception $e) {
    die("Connection failed: " . $e->getMessage());
}

// Enable MySQLi error reporting
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Create audit_logs table if it doesn't exist
$create_table_sql = "CREATE TABLE IF NOT EXISTS audit_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    action VARCHAR(255) NOT NULL,
    details TEXT,
    timestamp DATETIME NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id)
)";
if (!$conn->query($create_table_sql)) {
    error_log("Failed to create audit_logs table: " . $conn->error);
}

function send_notification($conn, $user_id, $message) {
    $stmt = $conn->prepare("INSERT INTO notifications (user_id, message, is_read, created_at) VALUES (?, ?, 0, NOW())");
    if ($stmt === false) {
        error_log("Prepare failed for send_notification: " . $conn->error);
        return false;
    }
    $stmt->bind_param("is", $user_id, $message);
    $result = $stmt->execute();
    $stmt->close();
    return $result;
}

function log_audit($conn, $user_id, $action, $details) {
    $stmt = $conn->prepare("INSERT INTO audit_logs (user_id, action, details, timestamp) VALUES (?, ?, ?, NOW())");
    if ($stmt === false) {
        error_log("Prepare failed for log_audit: " . $conn->error);
        return false;
    }
    $stmt->bind_param("iss", $user_id, $action, $details);
    $result = $stmt->execute();
    $stmt->close();
    return $result;
}
?>