<?php
// header.php - Common navigation bar for Vehicle Tracking System
// Ensure session is started (in case not started in including file)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        .navbar-brand { font-weight: bold; }
        .navbar { position: sticky; top: 0; z-index: 1030; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php">Vehicle Tracking System</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="main.php"><i class="fas fa-home"></i> Home</a>
                    </li>
                    <?php if (isset($_SESSION['role']) && $_SESSION['role'] == 'superuser') { ?>
                        <li class="nav-item">
                            <a class="nav-link" href="notifications.php?tab=notifications"><i class="fas fa-bell"></i> Notifications</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="manage_users.php?tab=system"><i class="fas fa-users-cog"></i> Manage Users</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="view_all_clients.php"><i class="fas fa-list"></i> All Clients</a>
                        </li>
                        
                    <?php } ?>
                    <?php if (isset($_SESSION['user_id'])) { ?>
                        <li class="nav-item">
                            <a class="nav-link btn btn-danger text-white" href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </nav>
</body>
</html>