<?php
// index.php - Main Entry Point for Vehicle Tracking System
session_start();
include 'db.php';

// Check if user is logged in and redirect to appropriate dashboard
if (isset($_SESSION['user_id']) && isset($_SESSION['role'])) {
    if ($_SESSION['role'] == 'sales') {
        header("Location: sales_dashboard.php");
    } elseif ($_SESSION['role'] == 'tech') {
        header("Location: tech_dashboard.php");
    } elseif ($_SESSION['role'] == 'technician') {
        header("Location: technician_dashboard.php");
    }
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vehicle Tracking System</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .hero {
            background: linear-gradient(135deg, #007bff, #6610f2);
            color: white;
            padding: 50px 0;
            text-align: center;
            border-radius: 10px;
        }
        .hero h1 {
            font-size: 2.5rem;
            margin-bottom: 20px;
        }
        .hero p {
            font-size: 1.2rem;
        }
        .btn-login {
            font-size: 1.1rem;
            padding: 10px 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="hero mt-5">
            <h1>Welcome to Vehicle Tracking System</h1>
            <p>Streamline your vehicle tracking installations with our automated, role-based platform.</p>
            <a href="login.php" class="btn btn-light btn-login mt-3">Login to Your Dashboard</a>
        </div>
        <div class="text-center mt-4">
            <p>Manage clients, assign technicians, and track installations efficiently.</p>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>