<?php
// view_installation.php - Display detailed installation information
include 'auth.php';
if ($_SESSION['role'] != 'tech') {
    echo "Access Denied.";
    exit();
}

$client_id = isset($_GET['client_id']) ? (int)$_GET['client_id'] : 0;
if ($client_id <= 0) {
    header("Location: tech_dashboard.php");
    exit();
}

// Fetch installation and client details
$sql = "SELECT c.id AS client_id, c.name, c.details AS client_details, c.contact_email, c.contact_phone, c.address, r.name AS region_name, i.gadget_details, i.vehicle_details, i.installation_date, i.notes, u.username AS tech_name, s.username AS sales_name
        FROM clients c 
        JOIN installations i ON c.id = i.client_id 
        JOIN regions r ON c.region_id = r.id 
        LEFT JOIN users u ON c.assigned_tech_id = u.id 
        LEFT JOIN users s ON c.created_by = s.id 
        WHERE c.id = ? AND c.status = 'Completed'";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Prepare failed: " . $conn->error);
}
$stmt->bind_param("i", $client_id);
$stmt->execute();
$result = $stmt->get_result();
$installation = $result->fetch_assoc();
$stmt->close();

if (!$installation) {
    $_SESSION['toast'] = ['type' => 'danger', 'message' => 'Installation not found or not completed.'];
    header("Location: tech_dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Installation - Vehicle Tracking System</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { background-color: #f4f6f9; }
        .card { border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .toast-container { position: fixed; top: 20px; right: 20px; z-index: 1055; }
        .details-section { background-color: #f8f9fa; padding: 15px; border-radius: 5px; margin-top: 10px; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php">Vehicle Tracking System</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="tech_dashboard.php"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>
                <a class="nav-link btn btn-danger text-white" href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </div>
        </div>
    </nav>
    <div class="container mt-5">
        <?php if (isset($_SESSION['toast'])) { ?>
            <div class="toast-container">
                <div class="toast align-items-center text-white bg-<?php echo htmlspecialchars($_SESSION['toast']['type']); ?> border-0" role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body">
                            <?php echo htmlspecialchars($_SESSION['toast']['message']); ?>
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                </div>
            </div>
            <?php unset($_SESSION['toast']); ?>
        <?php } ?>
        <h2 class="mb-4">Installation Details for <?php echo htmlspecialchars($installation['name']); ?></h2>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Installation Information</h5>
                <dl class="row">
                    <dt class="col-sm-3">Client ID</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['client_id']); ?></dd>
                    <dt class="col-sm-3">Client Name</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['name']); ?></dd>
                    <dt class="col-sm-3">Contact Email</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['contact_email'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Contact Phone</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['contact_phone'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Address</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['address'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Technician</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['tech_name'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Sales Person</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['sales_name'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Region</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['region_name']); ?></dd>
                    <dt class="col-sm-3">Gadget Details</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['gadget_details'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Vehicle Details</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['vehicle_details'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Installation Date</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['installation_date'] ?? 'N/A'); ?></dd>
                    <dt class="col-sm-3">Notes</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($installation['notes'] ?? 'N/A'); ?></dd>
                </dl>
                <div class="details-section">
                    <h6>Sales Details</h6>
                    <p><?php echo htmlspecialchars($installation['client_details'] ?? 'No sales details provided.'); ?></p>
                </div>
                <a href="tech_dashboard.php" class="btn btn-primary"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            var toastElList = [].slice.call(document.querySelectorAll('.toast'));
            var toastList = toastElList.map(function(toastEl) {
                return new bootstrap.Toast(toastEl, {
                    autohide: true,
                    delay: 5000
                });
            });
            toastList.forEach(function(toast) {
                toast.show();
            });
        });
    </script>
</body>
</html>